package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.MaterialDealVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报废处置主表
 *
 * @author generator
 */
@Controller
@RequestMapping("materialDeal")
public class MaterialDealController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialDealService service;

    @Autowired
    private IBillCodeApi billCodeApi;


    //项目单据编码规则
    public static final String EJC_MATERIAL_DEAL_XM = "EJC_MATERIAL_DEAL_XM";

    //公司单据编码规则
    public static final String EJC_MATERIAL_DEAL_GS = "EJC_MATERIAL_DEAL_GS";

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IGoodsService goodsService;


    @Autowired
    ICommonBusinessService materialDeal;


    @RequestMapping(value = "/del", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDealVO> del() {
        materialDeal.beforeAbstainingProcessor(457604785388126258L, null, null);
        return CommonResponse.success("查询详情数据成功！", null);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialDealVO> saveOrUpdate(@RequestBody MaterialDealVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            String billCodeRule = saveorUpdateVO.getBelongType() == 0 ? EJC_MATERIAL_DEAL_XM : EJC_MATERIAL_DEAL_GS;
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            saveorUpdateVO.setBillCode(codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setFinishState(0);
        }
        List<MaterialDealDetailVO> materialDealDetail = saveorUpdateVO.getMaterialDealDetail();
        if (CollectionUtils.isNotEmpty(materialDealDetail)) {
            QueryParam param = new QueryParam();
            param.getParams().put("belongType", new Parameter(QueryParam.EQ, saveorUpdateVO.getBelongType()));
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, saveorUpdateVO.getOrgId()));

            List<Long> assetIds = materialDealDetail.stream().map(MaterialDealDetailVO::getAssetId).collect(Collectors.toList());
            param.getParams().put("assetId", new Parameter(QueryParam.IN, assetIds));
            //在售状态 和 待回收状态
            param.getParams().put("status", new Parameter(QueryParam.IN, Arrays.asList(0, 3)));
            List<GoodsEntity> goodsEntities = goodsService.queryList(param);
            if (CollectionUtils.isNotEmpty(goodsEntities)) {
                //Map<Long, GoodsEntity> assetMap = goodsEntities.stream().collect(Collectors.toMap(GoodsEntity::getAssetId, account -> account));
                Map<Long, List<GoodsEntity>> assetMap = goodsEntities.stream().collect(Collectors.groupingBy(GoodsEntity::getAssetId));

                for (MaterialDealDetailVO m : materialDealDetail) {
                    Long assetId = m.getAssetId();
                    List<GoodsEntity> onGoodsEntities = assetMap.get(assetId);
                    Integer assetType = m.getAssetType();
                    if (1 == assetType && CollectionUtils.isNotEmpty(onGoodsEntities)) {
                        //台车
                        return CommonResponse.error("资产编号【" + m.getAssetCode() + "】的台车已被上架锁定中,暂不能处置！");
                    } else {
                        BigDecimal dealNum = m.getDealNum();
                        BigDecimal onNum = m.getOnNum();
                        if (dealNum.compareTo(onNum) > 0) {
                            return CommonResponse.error("资产编号【" + m.getAssetCode() + "】的处置数量不能大于在场数量！");
                        }
                        if(CollectionUtils.isNotEmpty(onGoodsEntities)){
                            BigDecimal nums = BigDecimal.ZERO;
                            for(GoodsEntity g : onGoodsEntities){
                                nums = nums.add(g.getRotatableNums() != null ? g.getRotatableNums() : BigDecimal.ZERO);
                            }
                            BigDecimal canDealNum = onNum.subtract(nums);
                            if (dealNum.compareTo(canDealNum) > 0) {
                                return CommonResponse.error("资产编号【" + m.getAssetCode() + "】" +
                                        "的处置数量不能大于可处置数量, 当前资产在场数量:" + onNum.setScale(2) + ", 上架锁定数量:" + nums.setScale(2) + ", 可处置数量:" + (BigDecimal.ZERO.compareTo(canDealNum) > 0 ? 0.00 : canDealNum.setScale(2)) + "！");
                            }
                        }
                    }
                }
            }
        }
        MaterialDealEntity entity = BeanMapper.map(saveorUpdateVO, MaterialDealEntity.class);
        service.saveOrUpdate(entity, false);
        MaterialDealVO vo = BeanMapper.map(entity, MaterialDealVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }



    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDealVO> queryDetail(Long id) {
        MaterialDealEntity entity = service.selectById(id);
        MaterialDealVO vo = BeanMapper.map(entity, MaterialDealVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDealVO> vos) {
        service.removeByIds(vos.stream().map(MaterialDealVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 项目周转材处置查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //项目
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));

        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialDealEntity> page = service.queryPage(param, false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList4Org  公司周转材处置查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList4Org", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList4Org(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //公司
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialDealEntity> page = service.queryPage(param, false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
