package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.asset.bean.MaterialDealDetailEntity;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@Service("materialDeal")
public class MaterialDealBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IMaterialDealService service;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialDealEntity materialDealEntity = service.selectById(billId);
        List<MaterialDealDetailEntity> materialDealDetail = materialDealEntity.getMaterialDealDetail();
        List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
        TurnoverRecordEntity turnoverRecordEntity = null;
        for (MaterialDealDetailEntity materialDealDetailEntity : materialDealDetail) {
            if (materialDealEntity.getBelongType() == 0) {
                turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.项目资产处置);
            } else {
                turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.公司资产处置);
            }

            turnoverRecordEntity.setMaterialTypeName(materialDealDetailEntity.getMaterialTypeName());
            turnoverRecordEntity.setMaterialTypeCode(materialDealDetailEntity.getMaterialTypeCode());
            turnoverRecordEntity.setMaterialTypeId(materialDealDetailEntity.getMaterialTypeId());
            turnoverRecordEntity.setMaterialCode(materialDealDetailEntity.getMaterialCode());
            turnoverRecordEntity.setMaterialId(materialDealDetailEntity.getMaterialId());
            turnoverRecordEntity.setMaterialName(materialDealDetailEntity.getMaterialName());
            turnoverRecordEntity.setSpec(materialDealDetailEntity.getSpec());
            turnoverRecordEntity.setUnit(materialDealDetailEntity.getUnit());
            turnoverRecordEntity.setAssetId(materialDealDetailEntity.getAssetId());
            turnoverRecordEntity.setAssetCode(materialDealDetailEntity.getAssetCode());
            turnoverRecordEntity.setAssetType(materialDealDetailEntity.getAssetType());
            turnoverRecordEntity.setOrgId(materialDealEntity.getOrgId());
            turnoverRecordEntity.setOrgName(materialDealEntity.getOrgName());
            turnoverRecordEntity.setProjectId(materialDealEntity.getProjectId());
            turnoverRecordEntity.setProjectName(materialDealEntity.getProjectName());
            turnoverRecordEntity.setSourceDate(materialDealEntity.getBillDate());
            turnoverRecordEntity.setSourceId(materialDealEntity.getId());
            turnoverRecordEntity.setSourceDetailId(materialDealDetailEntity.getId());
            turnoverRecordEntity.setBelongType(materialDealEntity.getBelongType());
            turnoverRecordEntity.setAssetBelongType(materialDealDetailEntity.getAssetBelongType());
            turnoverRecordEntity.setBelongOrgId(materialDealDetailEntity.getBelongOrgId());
            turnoverRecordEntity.setBelongOrgName(materialDealDetailEntity.getBelongOrgName());
            BigDecimal deal = materialDealDetailEntity.getDealNum() == null ? BigDecimal.ZERO : materialDealDetailEntity.getDealNum();
            turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(deal));
            turnoverRecordEntitList.add(turnoverRecordEntity);
        }
        turnoverRecordService.saveBatch(turnoverRecordEntitList);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //处置完成 不能弃审
        MaterialDealEntity materialDealEntity = service.getById(billId);
        if (materialDealEntity != null) {
            if (materialDealEntity.getFinishState() > 0) {
                return CommonResponse.error("该单据已补录附件或处置完成,不可弃审!");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, materialDealEntity.getId()));
            QueryWrapper<TurnoverRecordEntity> queryWrapper = changeToQueryWrapper(param);
            turnoverRecordService.remove(queryWrapper);
        }
        return CommonResponse.success();
    }


    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


}
