/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.mapper.AllotMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotService")
public class AllotServiceImpl
extends BaseServiceImpl<AllotMapper, AllotEntity>
implements IAllotService {
    private static final String PANHUO_ZC = "ASSET_DD";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    @Override
    public AllotVO saveAllot(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = (AllotEntity)((Object)BeanMapper.map((Object)vo, AllotEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        TurnoverRecordEntity saveEntity = (TurnoverRecordEntity)((Object)BeanMapper.map((Object)((Object)entity), TurnoverRecordEntity.class));
        if (0 == entity.getOrderType()) {
            saveEntity.setSourceType(TurnoverTypeEnum.\u8d44\u4ea7\u8c03\u62e8.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.\u8d44\u4ea7\u8c03\u62e8.getName());
        } else {
            saveEntity.setSourceType(TurnoverTypeEnum.\u8d44\u4ea7\u79df\u8d41.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.\u8d44\u4ea7\u79df\u8d41.getName());
        }
        saveEntity.setSourceDate(entity.getCreateTime());
        saveEntity.setSourceId(entity.getId());
        saveEntity.setTon(entity.getCapacity());
        saveEntity.setSourceDetailId(entity.getGoodsId());
        saveEntity.setOrgId(entity.getSellOrg());
        saveEntity.setOrgName(entity.getSellOrgName());
        saveEntity.setProjectId(entity.getSellProject());
        saveEntity.setProjectName(entity.getSellProjectName());
        saveEntity.setPrice(entity.getPrice());
        saveEntity.setTotalMoney(entity.getAmount());
        saveEntity.setNum(BigDecimal.ZERO.subtract(entity.getNums() == null ? BigDecimal.ZERO : entity.getNums()));
        this.turnoverRecordService.save((Object)saveEntity);
        AllotVO resvo = (AllotVO)BeanMapper.map((Object)((Object)entity), AllotVO.class);
        return resvo;
    }
}

