/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.CheckDetailVO;
import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.RecordVO;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"turnoverRecord"})
public class TurnoverRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITurnoverRecordService service;
    @Autowired
    private IGoodsService iGoodsService;
    @Autowired
    private ICheckService iCheckService;
    @Autowired
    private IAllotService iAllotService;
    @Autowired
    private IMaterialDealService iMaterialDealService;
    @Autowired
    IMaterialApi materialApi;

    @RequestMapping(value={"/treeMaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> treeMaterialList(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryWrapper wrapper;
        List<TurnoverRecordVO> list;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("materialTypeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter("eq", (Object)assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter("eq", (Object)assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            }
            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter("eq", (Object)belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                Integer assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter("eq", (Object)assetBelongType));
            }
        }
        if (CollectionUtil.isNotEmpty(list = this.service.queryMaterialTreeRef(wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param)))) {
            List materialTypeIds = list.stream().map(TurnoverRecordVO::getMaterialTypeId).collect(Collectors.toList());
            CommonResponse categoryList = this.materialApi.queryCategoryListByChildren(materialTypeIds);
            List data = (List)categoryList.getData();
            List resultMapList = BeanMapper.mapList((Iterable)data, Map.class);
            return ResultAsTree.createTreeData((List)resultMapList);
        }
        return null;
    }

    @RequestMapping(value={"/onMaterialList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> onMaterialList(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="relyCondition", required=false) String relyCondition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("assetCode", "materialCode", "materialName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Number assetBelongType;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter("eq", (Object)assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter("eq", (Object)assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            }
            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter("eq", (Object)belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter("eq", (Object)assetBelongType));
            }
            if (null != conditionMap.get("materialTypeId")) {
                assetBelongType = Long.valueOf(conditionMap.get("materialTypeId").toString());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long materialTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("materialTypeId", new Parameter("eq", (Object)materialTypeId));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<TurnoverRecordVO> list = this.service.queryMaterialRef((Page<TurnoverRecordVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecordVO> queryRecord(@RequestBody QueryParam param) {
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        Long orgIdValue = orgId != null && orgId.getValue() != null ? Long.valueOf(String.valueOf(orgId.getValue())) : null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "asc");
        param.getParams().remove("orgId");
        List turnoverRecordEntities = this.service.queryList(param, false);
        List turnoverRecordVOS = BeanMapper.mapList((Iterable)turnoverRecordEntities, TurnoverRecordVO.class);
        RecordVO recordVO = new RecordVO();
        if (CollectionUtil.isNotEmpty((Collection)turnoverRecordVOS)) {
            recordVO.setAssetCode(((TurnoverRecordVO)turnoverRecordVOS.get(0)).getAssetCode());
            recordVO.setAssetType(((TurnoverRecordVO)turnoverRecordVOS.get(0)).getAssetType());
            if (1 == recordVO.getAssetType()) {
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (t.getTon() != null) {
                        recordVO.setTon(t.getTon());
                    }
                    if (t.getUseAssetCode() == null) continue;
                    recordVO.setUseAssetCode(t.getUseAssetCode());
                    recordVO.setUseTon(t.getUseTon());
                    recordVO.setUseAssetId(t.getUseAssetId());
                }
            } else {
                BigDecimal onNum = BigDecimal.ZERO;
                BigDecimal dealNum = BigDecimal.ZERO;
                BigDecimal buyNum = BigDecimal.ZERO;
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (!t.getOrgId().equals(orgIdValue)) continue;
                    if (t.getSourceType() != null && (TurnoverTypeEnum.\u516c\u53f8\u81ea\u91c7\u9a8c\u6536.getCode().equalsIgnoreCase(t.getSourceType()) || TurnoverTypeEnum.\u9879\u76ee\u81ea\u91c7\u9a8c\u6536.getCode().equalsIgnoreCase(t.getSourceType()))) {
                        buyNum = buyNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                    }
                    onNum = onNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                    if (t.getSourceType() == null || !TurnoverTypeEnum.\u516c\u53f8\u8d44\u4ea7\u5904\u7f6e.getCode().equalsIgnoreCase(t.getSourceType()) && !TurnoverTypeEnum.\u9879\u76ee\u8d44\u4ea7\u5904\u7f6e.getCode().equalsIgnoreCase(t.getSourceType())) continue;
                    dealNum = dealNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                }
                recordVO.setBuyNum(buyNum);
                recordVO.setOnNum(onNum);
                recordVO.setDealNum(dealNum.abs());
            }
            recordVO.setTurnoverRecords(turnoverRecordVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5468\u8f6c\u8bb0\u5f55\u6210\u529f\uff01", (Object)recordVO);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> saveOrUpdate(@RequestBody TurnoverRecordVO saveorUpdateVO) {
        TurnoverRecordEntity entity = (TurnoverRecordEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TurnoverRecordEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        TurnoverRecordVO vo = (TurnoverRecordVO)BeanMapper.map((Object)((Object)entity), TurnoverRecordVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> queryDetail(Long id) {
        TurnoverRecordEntity entity = (TurnoverRecordEntity)((Object)this.service.selectById(id));
        TurnoverRecordVO vo = (TurnoverRecordVO)BeanMapper.map((Object)((Object)entity), TurnoverRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TurnoverRecordVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TurnoverRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="materialCode") String materialCode) {
        ArrayList<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList = this.service.selectByProjectId(projectId, orgId);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            List<GoodsVO> goodsList;
            JSONObject vo = new JSONObject();
            vo.put("projectId", (Object)projectId);
            vo.put("orgId", (Object)orgId);
            if (turnoverRecordVO.getAssetType() != null) {
                vo.put("assetType", (Object)(turnoverRecordVO.getAssetType() == 0 ? "\u5468\u8f6c\u6750" : "\u53f0\u8f66"));
            }
            vo.put("spec", (Object)turnoverRecordVO.getSpec());
            vo.put("unit", (Object)turnoverRecordVO.getUnit());
            vo.put("materialName", (Object)turnoverRecordVO.getMaterialName());
            if (materialCode != null && !"".equals(materialCode) && !turnoverRecordVO.getMaterialCode().equals(materialCode)) continue;
            vo.put("projectName", (Object)turnoverRecordVO.getProjectName());
            List<GoodsVO> goodsVOList = this.iGoodsService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
            if (goodsVOList != null && !goodsVOList.isEmpty()) {
                for (GoodsVO goodsVO : goodsVOList) {
                    vo.put("siteNums", (Object)goodsVO.getSiteNums());
                    vo.put("rotatableNums", (Object)goodsVO.getRotatableNums());
                    vo.put("rotatableMoney", (Object)MathUtil.safeMultiply(goodsVO.getPrice(), goodsVO.getRotatableNums()));
                }
            }
            if ((goodsList = this.iGoodsService.selectRecover(projectId, orgId, turnoverRecordVO.getMaterialName())) != null && !goodsList.isEmpty()) {
                for (GoodsVO goodsVO2 : goodsList) {
                    vo.put("recoverNum", (Object)goodsVO2.getRemainingNums());
                    vo.put("recoverMoney", (Object)MathUtil.safeMultiply(goodsVO2.getPrice(), goodsVO2.getRemainingNums()));
                }
            }
            List<Long> list = this.iCheckService.selectCheckId(projectId, orgId);
            BigDecimal checkNum = new BigDecimal(0);
            BigDecimal checkTaxMoney = new BigDecimal(0);
            BigDecimal allotMoney = new BigDecimal(0);
            BigDecimal allotNum = new BigDecimal(0);
            for (Long checkId : list) {
                List<CheckDetailVO> checkDetailVOList = this.iCheckService.selectByMaterialName(checkId, turnoverRecordVO.getMaterialName());
                if (checkDetailVOList == null || checkDetailVOList.isEmpty()) continue;
                for (CheckDetailVO checkDetailVO : checkDetailVOList) {
                    checkNum = MathUtil.safeAdd(checkNum, checkDetailVO.getCheckNum());
                    checkTaxMoney = MathUtil.safeAdd(checkTaxMoney, checkDetailVO.getCheckTaxMoney());
                    allotMoney = MathUtil.safeAdd(allotMoney, checkDetailVO.getAllotMoney());
                    allotNum = MathUtil.safeAdd(allotNum, checkDetailVO.getAllotNum());
                }
            }
            vo.put("checkNum", (Object)checkNum);
            vo.put("checkTaxMoney", (Object)checkTaxMoney);
            vo.put("allotMoney", (Object)allotMoney);
            vo.put("allotNum", (Object)allotNum);
            List<Long> allotIdList = this.iCheckService.selectAllotId(projectId, orgId);
            BigDecimal nums = new BigDecimal(0);
            BigDecimal amount = new BigDecimal(0);
            for (Long allot : allotIdList) {
                List<AllotVO> allotVOList = this.iAllotService.selectByMaterialName(allot, turnoverRecordVO.getMaterialName());
                if (allotVOList == null || allotVOList.isEmpty()) continue;
                for (AllotVO allotVO : allotVOList) {
                    nums = MathUtil.safeAdd(nums, allotVO.getNums());
                    amount = MathUtil.safeAdd(amount, allotVO.getAmount());
                }
            }
            vo.put("nums", (Object)nums);
            vo.put("amount", (Object)amount);
            List<MaterialDealDetailVO> dealDetailVOList = this.iMaterialDealService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
            if (dealDetailVOList != null && !dealDetailVOList.isEmpty()) {
                for (MaterialDealDetailVO materialDealDetailVO : dealDetailVOList) {
                    vo.put("dealNum", (Object)materialDealDetailVO.getDealNum());
                    vo.put("dealMoney", (Object)materialDealDetailVO.getDealMoney());
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", voList);
    }

    @RequestMapping(value={"/queryDetailProjectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailProjectDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="materialName") String materialName) {
        ArrayList<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList = this.service.selectDetail(projectId, orgId, materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            vo.put("projectId", (Object)projectId);
            vo.put("orgId", (Object)orgId);
            if (turnoverRecordVO.getAssetType() != null) {
                vo.put("assetType", (Object)(turnoverRecordVO.getAssetType() == 0 ? "\u5468\u8f6c\u6750" : "\u53f0\u8f66"));
            }
            vo.put("materialCode", (Object)turnoverRecordVO.getMaterialCode());
            vo.put("materialName", (Object)turnoverRecordVO.getMaterialName());
            vo.put("spec", (Object)turnoverRecordVO.getSpec());
            vo.put("unit", (Object)turnoverRecordVO.getUnit());
            vo.put("num", (Object)turnoverRecordVO.getNum());
            vo.put("totalMoney", (Object)turnoverRecordVO.getTotalMoney());
            vo.put("sourceTypeName", (Object)turnoverRecordVO.getSourceTypeName());
            List<GoodsVO> goodsList = this.iGoodsService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
            for (GoodsVO goodsVO : goodsList) {
                List<AllotVO> allotVOList = this.iAllotService.queryDetail(goodsVO.getId(), turnoverRecordVO.getMaterialName());
                for (AllotVO allotVO : allotVOList) {
                    if ("".equals(orgId)) {
                        vo.put("buyProjectName", (Object)allotVO.getBuyProjectName());
                        vo.put("sellProjectName", (Object)allotVO.getSellProjectName());
                        continue;
                    }
                    vo.put("buyOrgName", (Object)allotVO.getBuyOrgName());
                    vo.put("sellOrgName", (Object)allotVO.getSellOrgName());
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", voList);
    }

    @RequestMapping(value={"/queryDetailDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="materialName") String materialName) {
        ArrayList<JSONObject> voList = new ArrayList<JSONObject>();
        if (("".equals(orgId) || orgId == null) && ("".equals(projectId) || projectId == null)) {
            List<AllotVO> allotList = this.iAllotService.selectMaterialName(materialName);
            for (AllotVO allotVO : allotList) {
                JSONObject vo = new JSONObject();
                if (allotVO.getAssetType() != null) {
                    vo.put("assetType", (Object)(allotVO.getAssetType() == 0 ? "\u5468\u8f6c\u6750" : "\u53f0\u8f66"));
                }
                vo.put("materialCode", (Object)allotVO.getMaterialCode());
                vo.put("materialName", (Object)allotVO.getMaterialName());
                vo.put("spec", (Object)allotVO.getSpec());
                vo.put("buyOrgName", (Object)allotVO.getBuyOrgName());
                voList.add(vo);
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", voList);
        }
        List<TurnoverRecordVO> turnoverRecordVOList = this.service.selectDetail(projectId, orgId, materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            vo.put("orgId", (Object)orgId);
            if (turnoverRecordVO.getAssetType() != null) {
                vo.put("assetType", (Object)(turnoverRecordVO.getAssetType() == 0 ? "\u5468\u8f6c\u6750" : "\u53f0\u8f66"));
            }
            vo.put("materialCode", (Object)turnoverRecordVO.getMaterialCode());
            vo.put("materialName", (Object)turnoverRecordVO.getMaterialName());
            vo.put("spec", (Object)turnoverRecordVO.getSpec());
            vo.put("checkNum", (Object)turnoverRecordVO.getNum());
            List<GoodsVO> goodsList = this.iGoodsService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
            for (GoodsVO goodsVO : goodsList) {
                List<AllotVO> allotVOList = this.iAllotService.queryDetail(goodsVO.getId(), turnoverRecordVO.getMaterialName());
                for (AllotVO allotVO : allotVOList) {
                    vo.put("buyOrgName", (Object)allotVO.getBuyOrgName());
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", voList);
    }

    @RequestMapping(value={"/queryProjectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryProjectDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="materialName") String materialName) {
        ArrayList<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList = this.service.selectProjectDetail(materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            List<GoodsVO> goodsList;
            JSONObject vo = new JSONObject();
            vo.put("projectId", (Object)turnoverRecordVO.getProjectId());
            if (turnoverRecordVO.getAssetType() != null) {
                vo.put("assetType", (Object)(turnoverRecordVO.getAssetType() == 0 ? "\u5468\u8f6c\u6750" : "\u53f0\u8f66"));
            }
            vo.put("spec", (Object)turnoverRecordVO.getSpec());
            vo.put("unit", (Object)turnoverRecordVO.getUnit());
            vo.put("materialName", (Object)turnoverRecordVO.getMaterialName());
            vo.put("projectName", (Object)turnoverRecordVO.getProjectName());
            List<GoodsVO> goodsVOList = this.iGoodsService.selectDetail(turnoverRecordVO.getProjectId(), orgId, turnoverRecordVO.getMaterialName());
            if (goodsVOList != null && !goodsVOList.isEmpty()) {
                for (GoodsVO goodsVO : goodsVOList) {
                    vo.put("siteNums", (Object)goodsVO.getSiteNums());
                    vo.put("rotatableNums", (Object)goodsVO.getRotatableNums());
                    vo.put("rotatableMoney", (Object)MathUtil.safeMultiply(goodsVO.getPrice(), goodsVO.getRotatableNums()));
                }
            }
            if ((goodsList = this.iGoodsService.selectRecover(turnoverRecordVO.getProjectId(), orgId, turnoverRecordVO.getMaterialName())) != null && !goodsList.isEmpty()) {
                for (GoodsVO goodsVO2 : goodsList) {
                    vo.put("recoverNum", (Object)goodsVO2.getRemainingNums());
                    vo.put("recoverMoney", (Object)MathUtil.safeMultiply(goodsVO2.getPrice(), goodsVO2.getRemainingNums()));
                }
            }
            List<Long> list = this.iCheckService.selectCheckId(turnoverRecordVO.getProjectId(), orgId);
            BigDecimal checkNum = new BigDecimal(0);
            BigDecimal checkTaxMoney = new BigDecimal(0);
            BigDecimal allotMoney = new BigDecimal(0);
            BigDecimal allotNum = new BigDecimal(0);
            for (Long checkId : list) {
                List<CheckDetailVO> checkDetailVOList = this.iCheckService.selectByMaterialName(checkId, turnoverRecordVO.getMaterialName());
                if (checkDetailVOList == null || checkDetailVOList.isEmpty()) continue;
                for (CheckDetailVO checkDetailVO : checkDetailVOList) {
                    checkNum = MathUtil.safeAdd(checkNum, checkDetailVO.getCheckNum());
                    checkTaxMoney = MathUtil.safeAdd(checkTaxMoney, checkDetailVO.getCheckTaxMoney());
                    allotMoney = MathUtil.safeAdd(allotMoney, checkDetailVO.getAllotMoney());
                    allotNum = MathUtil.safeAdd(allotNum, checkDetailVO.getAllotNum());
                }
            }
            vo.put("checkNum", (Object)checkNum);
            vo.put("checkTaxMoney", (Object)checkTaxMoney);
            vo.put("allotMoney", (Object)allotMoney);
            vo.put("allotNum", (Object)allotNum);
            List<Long> allotIdList = this.iCheckService.selectAllotId(turnoverRecordVO.getProjectId(), orgId);
            BigDecimal nums = new BigDecimal(0);
            BigDecimal amount = new BigDecimal(0);
            for (Long allot : allotIdList) {
                List<AllotVO> allotVOList = this.iAllotService.selectByMaterialName(allot, turnoverRecordVO.getMaterialName());
                if (allotVOList == null || allotVOList.isEmpty()) continue;
                for (AllotVO allotVO : allotVOList) {
                    nums = MathUtil.safeAdd(nums, allotVO.getNums());
                    amount = MathUtil.safeAdd(amount, allotVO.getAmount());
                }
            }
            vo.put("nums", (Object)nums);
            vo.put("amount", (Object)amount);
            List<MaterialDealDetailVO> dealDetailVOList = this.iMaterialDealService.selectDetail(turnoverRecordVO.getProjectId(), orgId, turnoverRecordVO.getMaterialName());
            if (dealDetailVOList != null && !dealDetailVOList.isEmpty()) {
                for (MaterialDealDetailVO materialDealDetailVO : dealDetailVOList) {
                    vo.put("dealNum", (Object)materialDealDetailVO.getDealNum());
                    vo.put("dealMoney", (Object)materialDealDetailVO.getDealMoney());
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", voList);
    }
}

