/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.PricePublishDetailEntity;
import com.ejianc.business.asset.bean.PricePublishEntity;
import com.ejianc.business.asset.service.IPricePublishDetailService;
import com.ejianc.business.asset.service.IPricePublishService;
import com.ejianc.business.asset.vo.PricePublishDetailVO;
import com.ejianc.business.asset.vo.PricePublishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pricePublish"})
public class PricePublishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPricePublishService service;
    @Autowired
    private IPricePublishDetailService pricePublishDetailService;
    public static final String EJC_PRICE_PUBLISH = "EJC_PRICE_PUBLISH";

    @RequestMapping(value={"/enabled"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody PricePublishVO saveorUpdateVO) {
        Long id = saveorUpdateVO.getId();
        PricePublishEntity publishEntity = (PricePublishEntity)((Object)this.service.getById(id));
        if (0 == publishEntity.getEnabled()) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("enabled", new Parameter("eq", (Object)1));
            param.getParams().put("id", new Parameter("ne", (Object)publishEntity.getId()));
            List pricePublishEntities = this.service.queryList(param);
            if (CollectionUtil.isNotEmpty((Collection)pricePublishEntities)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5df2\u5b58\u5728\u542f\u7528\u72b6\u6001\u7684\u5355\u636e!");
            }
            publishEntity.setEnabled(1);
        } else {
            publishEntity.setEnabled(0);
        }
        PricePublishEntity entity = (PricePublishEntity)((Object)BeanMapper.map((Object)((Object)publishEntity), PricePublishEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        PricePublishVO vo = (PricePublishVO)BeanMapper.map((Object)((Object)entity), PricePublishVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PricePublishVO> saveOrUpdate(@RequestBody PricePublishVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode(EJC_PRICE_PUBLISH, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveorUpdateVO.setBillCode((String)codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setEnabled(Integer.valueOf(0));
        }
        PricePublishEntity entity = (PricePublishEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PricePublishEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        PricePublishVO vo = (PricePublishVO)BeanMapper.map((Object)((Object)entity), PricePublishVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PricePublishVO> queryDetail(Long id) {
        PricePublishEntity entity = (PricePublishEntity)((Object)this.service.selectById(id));
        PricePublishVO vo = (PricePublishVO)BeanMapper.map((Object)((Object)entity), PricePublishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PricePublishVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PricePublishVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("employeeName", "billCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("enabled", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PricePublishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGuidePrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PricePublishDetailVO>> queryGuidePrice(@RequestBody List<PricePublishDetailVO> vos) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("enabled", 1);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        HashMap beans = new HashMap();
        List<PricePublishDetailEntity> pricePublishDetailEntities = this.service.queryDetail(param);
        if (CollectionUtil.isNotEmpty(pricePublishDetailEntities)) {
            HashMap<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>();
            for (PricePublishDetailEntity e : pricePublishDetailEntities) {
                Long mid = e.getMaterialId() != null ? e.getMaterialId() : e.getMaterialTypeId();
                priceMap.put(mid, e.getGuidePrice());
            }
            for (PricePublishDetailVO v : vos) {
                Long materialId = v.getMaterialId();
                Long materialTypeId = v.getMaterialTypeId();
                BigDecimal price = priceMap.get(materialId) != null ? (BigDecimal)priceMap.get(materialId) : (BigDecimal)priceMap.get(materialTypeId);
                v.setGuidePrice(price);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/pricePublishRef"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PricePublishVO>> pricePublishRef(@RequestBody QueryParam param) {
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("enabled", "desc");
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PricePublishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PricePublishVO> queryDetailRef(Long id) {
        PricePublishEntity entity = (PricePublishEntity)((Object)this.service.selectById(id));
        entity.setId(null);
        entity.setEnabled(0);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setVersion(null);
        entity.setTenantId(null);
        entity.setBillDate(new Date());
        entity.setPublishDate(new Date());
        entity.setBillState(null);
        List<PricePublishDetailEntity> pricePublishDetail = entity.getPricePublishDetail();
        for (PricePublishDetailEntity p : pricePublishDetail) {
            p.setRowState("add");
            p.setPId(null);
            p.setCreateUserCode(null);
            p.setCreateTime(null);
            p.setUpdateTime(null);
            p.setUpdateUserCode(null);
            p.setVersion(null);
            p.setTenantId(null);
        }
        PricePublishVO vo = (PricePublishVO)BeanMapper.map((Object)((Object)entity), PricePublishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

