package com.ejianc.business.asset.consts;

/**
 * 周转记录来源操作类型
 * XMZCYS自采验收   项目  自采进场审批通过后插入
 * GSZCYS自采验收   公司  自采进场审批通过后插入
 * DBYS调拨验收    项目   调拨验收进场审批通过后插入
 * ZCHS资产回收    公司回收操作，插入一条公司资产回收数据，再插入一条项目回收退场(负)操作
 * HSTC回收退场（负）
 * XMZCCZ资产处置（负）项目 报废审批通过插入一条
 * GSZCCZ资产处置（负）公司 报废审批通过插入一条
 * ZCDB资产调拨（负） 订单完成后生成调拨单，并且插入一条记录
 * ZCLJ资产利旧（负）
 * JGSJ加工上架    公司加工加上，插入一条数据 编码为B，并且插入一条资产利旧(负)的数据 编码为A
 */
public enum TurnoverTypeEnum {

    项目自采验收("XMZCYS", "自采验收"),
    公司自采验收("GSZCYS", "自采验收"),
    调拨验收("DBYS", "调拨验收"),
    租赁验收("ZLYS", "租赁验收"),
    资产回收("ZCHS", "资产回收"),
    回收退场("HSTC", "回收退场"),
    项目资产处置("XMZCCZ", "资产处置"),
    公司资产处置("GSZCCZ", "资产处置"),
    资产调拨("ZCDB", "资产调拨"),
    资产租赁("ZCZL", "资产租赁"),
    资产利旧("ZCLJ", "资产利旧"),
    加工上架("JGSJ", "加工上架");

    private String code;

    private String name;


    TurnoverTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
