package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.MaterialDealDetailEntity;
import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.MaterialDealVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报废处置主表
 *
 * @author generator
 */
@Controller
@RequestMapping("materialDeal")
public class MaterialDealController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialDealService service;

    @Autowired
    private IBillCodeApi billCodeApi;


    //项目单据编码规则
    public static final String EJC_MATERIAL_DEAL_XM = "EJC_MATERIAL_DEAL_XM";

    //公司单据编码规则
    public static final String EJC_MATERIAL_DEAL_GS = "EJC_MATERIAL_DEAL_GS";

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IGoodsService goodsService;


    @Autowired
    ICommonBusinessService materialDeal;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;





    @RequestMapping(value = "/get", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDealVO> get() {

        materialDeal.afterApprovalProcessor(471028645122162710L ,null, null);
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialDealVO> saveOrUpdate(@RequestBody MaterialDealVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            String billCodeRule = saveorUpdateVO.getBelongType() == 0 ? EJC_MATERIAL_DEAL_XM : EJC_MATERIAL_DEAL_GS;
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            saveorUpdateVO.setBillCode(codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setFinishState(0);
        }
        List<MaterialDealDetailVO> materialDealDetail = saveorUpdateVO.getMaterialDealDetail();
        if (CollectionUtils.isNotEmpty(materialDealDetail)) {
            for (MaterialDealDetailVO v : materialDealDetail) {
                LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
                lambdachange.eq(GoodsEntity::getTenantId, InvocationInfoProxy.getTenantid());
                lambdachange.eq(GoodsEntity::getAssetId, v.getAssetId());
                lambdachange.eq(GoodsEntity::getOrgId, v.getOrgId());
                lambdachange.in(GoodsEntity::getStatus, 0, 3);//0-在售，3-待回收 需将这两种状态的可周转数量取到
                List<GoodsEntity> goodsEntities = goodsService.list(lambdachange);
                //以上架单子的未成交的剩余数量累计
                BigDecimal remianNums = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(goodsEntities)) {
                    remianNums = goodsEntities.stream().map(e -> e.getRemainingNums() == null ? BigDecimal.ZERO : e.getRemainingNums()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                //可处置数量 在场数量减去已经上架的未成交的数量
                BigDecimal maxNextAdd = v.getOnNum().subtract(remianNums);

                if (MathUtil.isGreaterThan(v.getDealNum(), maxNextAdd)) {
                    return CommonResponse.error("该资产【" + v.getAssetCode() + "】处置数量已超过可处置数量，不可处置(请检查在售和待回收资产)");
                }
            }
        }


        MaterialDealEntity materialDealEntity = BeanMapper.map(saveorUpdateVO, MaterialDealEntity.class);

        //如果是处置完成， 则插入处置记录
        if(materialDealEntity.getFinishState() == 2){
            List<MaterialDealDetailEntity> dealDetail = materialDealEntity.getMaterialDealDetail();
            List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
            TurnoverRecordEntity turnoverRecordEntity = null;
            for (MaterialDealDetailEntity materialDealDetailEntity : dealDetail) {
                if (materialDealEntity.getBelongType() == 0) {
                    turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.项目资产处置);
                } else {
                    turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.公司资产处置);
                }

                turnoverRecordEntity.setMaterialTypeName(materialDealDetailEntity.getMaterialTypeName());
                turnoverRecordEntity.setMaterialTypeCode(materialDealDetailEntity.getMaterialTypeCode());
                turnoverRecordEntity.setMaterialTypeId(materialDealDetailEntity.getMaterialTypeId());
                turnoverRecordEntity.setMaterialCode(materialDealDetailEntity.getMaterialCode());
                turnoverRecordEntity.setMaterialId(materialDealDetailEntity.getMaterialId());
                turnoverRecordEntity.setMaterialName(materialDealDetailEntity.getMaterialName());
                turnoverRecordEntity.setSpec(materialDealDetailEntity.getSpec());
                turnoverRecordEntity.setUnit(materialDealDetailEntity.getUnit());
                turnoverRecordEntity.setAssetId(materialDealDetailEntity.getAssetId());
                turnoverRecordEntity.setAssetCode(materialDealDetailEntity.getAssetCode());
                turnoverRecordEntity.setAssetType(materialDealDetailEntity.getAssetType());
                turnoverRecordEntity.setOrgId(materialDealEntity.getOrgId());
                turnoverRecordEntity.setOrgName(materialDealEntity.getOrgName());
                turnoverRecordEntity.setProjectId(materialDealEntity.getProjectId());
                turnoverRecordEntity.setProjectName(materialDealEntity.getProjectName());
                turnoverRecordEntity.setSourceDate(materialDealEntity.getBillDate());
                turnoverRecordEntity.setSourceId(materialDealEntity.getId());
                turnoverRecordEntity.setSourceDetailId(materialDealDetailEntity.getId());
                turnoverRecordEntity.setBelongType(materialDealEntity.getBelongType());
                turnoverRecordEntity.setAssetBelongType(materialDealDetailEntity.getAssetBelongType());
                turnoverRecordEntity.setBelongOrgId(materialDealDetailEntity.getBelongOrgId());
                turnoverRecordEntity.setBelongOrgName(materialDealDetailEntity.getBelongOrgName());
                turnoverRecordEntity.setNum(MathUtil.convertToMinusNumber(materialDealDetailEntity.getDealNum()));
                turnoverRecordEntity.setPrice(materialDealDetailEntity.getDealPrice());
                turnoverRecordEntity.setTotalMoney(materialDealDetailEntity.getDealMoney());
                turnoverRecordEntitList.add(turnoverRecordEntity);
            }
            turnoverRecordService.saveBatch(turnoverRecordEntitList);

        }
        service.saveOrUpdate(materialDealEntity, false);
        MaterialDealVO vo = BeanMapper.map(materialDealEntity, MaterialDealVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDealVO> queryDetail(Long id) {
        MaterialDealEntity entity = service.selectById(id);
        MaterialDealVO vo = BeanMapper.map(entity, MaterialDealVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDealVO> vos) {
        service.removeByIds(vos.stream().map(MaterialDealVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 项目周转材处置查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //项目
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));

        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialDealEntity> page = service.queryPage(param, false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList4Org  公司周转材处置查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList4Org", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList4Org(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //公司
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialDealEntity> page = service.queryPage(param, false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}
