package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.PlanMapper;
import com.ejianc.business.asset.bean.PlanEntity;
import com.ejianc.business.asset.service.IPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private static final String EJC_CRG_PLAN = "EJC_CRG_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(planVO.getId() == null){
            planVO.setCheckState(0);
        }
        if(StringUtils.isEmpty(planVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EJC_CRG_PLAN,tenantId);
            if(billCode.isSuccess()) {
                planVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        PlanEntity entity = BeanMapper.map(planVO, PlanEntity.class);
        //汇总物资明细名称
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        List<String> materialNameList = new ArrayList<>();
        if(planDetail != null && planDetail.size() > 0){
            for (PlanDetailEntity applyDetailEntity : planDetail){
                if (!materialNameList.contains(applyDetailEntity.getMaterialName())){
                    materialNameList.add(applyDetailEntity.getMaterialName());
                }
            }
        }
        if(materialNameList != null && materialNameList.size() > 0){
            for(String materialNames : materialNameList){
                materialName = materialName + materialNames + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        planService.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
