package com.ejianc.business.panhuo.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_wbuy")
public class WbuyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 求购编号
    @TableField(value="buyer")
    private Long buyer; // 求购人
    @TableField(value="buyer_name")
    private String buyerName; // 求购人名称
    @TableField(value="mainimg_path")
    private String mainimgPath; // 资产主图URL
    @TableField(value="title")
    private String title; // 求购标题
    @TableField(value="end_date")
    private java.util.Date endDate; // 需求截止日期
    @TableField(value="label_name")
    private String labelName; // 标签名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="address_id")
    private Long addressId; // 地址主键
    @TableField(value="project_address")
    private String projectAddress; //
    @TableField(value="address_name")
    private String addressName; // 详细地址
    @TableField(value="lon")
    private Double lon; // 经度
    @TableField(value="lat")
    private Double lat; // 纬度
    @TableField(value="phone")
    private String phone; // 联系方式
    @TableField(value="name")
    private String name; // 联系人
    @TableField(value="first_location")
    private String firstLocation; // 所在地一级区域
    @TableField(value="second_location")
    private String secondLocation; // 所在地二级区域
    @TableField(value="third_location")
    private String thirdLocation; // 所在地三级区域
    @TableField(value="fourth_location")
    private String fourthLocation; // 所属城市
    @TableField(value="location")
    private java.lang.String location; // 所在地末级区域
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="buy_time")
    private java.util.Date buyTime; // 求购发布时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="endbuy_time")
    private java.util.Date endbuyTime; // 停止求购时间
    @TableField(value="status")
    private Integer status; // 求购状态(0-求购中,1-已关闭，2-暂存)
    @TableField(value="close_type")
    private Integer closeType; // 关闭类型0-手动关闭,1-到期关闭
    @TableField(value="closer")
    private Long closer; // 关闭人
    @TableField(value="note")
    private String note; // 求购说明
    @TableField(value="address")
    private String address; // 详细地址


    @TableField(exist = false)
    private java.lang.String distance; // 距离
    // 标签子表
    @TableField(exist = false)
    @SubEntity(serviceName="labeldetailService",pidName = "sourceId")
    private List<LabeldetailEntity> labels = new ArrayList<>();

    // 图片子表
    @TableField(exist = false)
    @SubEntity(serviceName="imgdetailService",pidName = "sourceId")
    private List<ImgdetailEntity> imgsPath = new ArrayList<>();

    // 求购物资子表
    @TableField(exist = false)
    @SubEntity(serviceName="categoryService",pidName = "wbuyId")
    private List<CategoryEntity> materialDetails = new ArrayList<>();

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public List<LabeldetailEntity> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailEntity> labels) {
        this.labels = labels;
    }

    public List<ImgdetailEntity> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailEntity> imgsPath) {
        this.imgsPath = imgsPath;
    }

    public List<CategoryEntity> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<CategoryEntity> materialDetails) {
        this.materialDetails = materialDetails;
    }

    /**
     * 求购编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 求购编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 求购人
     */
    public Long getBuyer() {
        return buyer;
    }

    /**
     * 求购人
     */
    public void setBuyer(Long buyer) {
        this.buyer = buyer;
    }
    /**
     * 求购人名称
     */
    public String getBuyerName() {
        return buyerName;
    }

    /**
     * 求购人名称
     */
    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    /**
     * 资产主图URL
     */
    public String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 求购标题
     */
    public String getTitle() {
        return title;
    }

    /**
     * 求购标题
     */
    public void setTitle(String title) {
        this.title = title;
    }
    /**
     * 需求截止日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 需求截止日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 标签名称
     */
    public String getLabelName() {
        return labelName;
    }

    /**
     * 标签名称
     */
    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
    /**
     * 项目主键
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 地址主键
     */
    public Long getAddressId() {
        return addressId;
    }

    /**
     * 地址主键
     */
    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }
    /**
     * 
     */
    public String getProjectAddress() {
        return projectAddress;
    }

    /**
     * 
     */
    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    /**
     * 详细地址
     */
    public String getAddressName() {
        return addressName;
    }

    /**
     * 详细地址
     */
    public void setAddressName(String addressName) {
        this.addressName = addressName;
    }
    /**
     * 经度
     */
    public Double getLon() {
        return lon;
    }

    /**
     * 经度
     */
    public void setLon(Double lon) {
        this.lon = lon;
    }
    /**
     * 纬度
     */
    public Double getLat() {
        return lat;
    }

    /**
     * 纬度
     */
    public void setLat(Double lat) {
        this.lat = lat;
    }
    /**
     * 联系方式
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 联系方式
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 联系人
     */
    public String getName() {
        return name;
    }

    /**
     * 联系人
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 所在地一级区域
     */
    public String getFirstLocation() {
        return firstLocation;
    }

    /**
     * 所在地一级区域
     */
    public void setFirstLocation(String firstLocation) {
        this.firstLocation = firstLocation;
    }
    /**
     * 所在地二级区域
     */
    public String getSecondLocation() {
        return secondLocation;
    }

    /**
     * 所在地二级区域
     */
    public void setSecondLocation(String secondLocation) {
        this.secondLocation = secondLocation;
    }
    /**
     * 所在地三级区域
     */
    public String getThirdLocation() {
        return thirdLocation;
    }

    /**
     * 所在地三级区域
     */
    public void setThirdLocation(String thirdLocation) {
        this.thirdLocation = thirdLocation;
    }
    /**
     * 所属城市
     */
    public String getFourthLocation() {
        return fourthLocation;
    }

    /**
     * 所属城市
     */
    public void setFourthLocation(String fourthLocation) {
        this.fourthLocation = fourthLocation;
    }
    /**
     * 所在地末级区域
     */
    public String getLocation() {
        return location;
    }

    /**
     * 所在地末级区域
     */
    public void setLocation(String location) {
        this.location = location;
    }
    /**
     * 求购发布时间
     */
    public java.util.Date getBuyTime() {
        return buyTime;
    }

    /**
     * 求购发布时间
     */
    public void setBuyTime(java.util.Date buyTime) {
        this.buyTime = buyTime;
    }
    /**
     * 停止求购时间
     */
    public java.util.Date getEndbuyTime() {
        return endbuyTime;
    }

    /**
     * 停止求购时间
     */
    public void setEndbuyTime(java.util.Date endbuyTime) {
        this.endbuyTime = endbuyTime;
    }
    /**
     * 求购状态(0-求购中,1-已关闭，2-暂存)
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 求购状态(0-求购中,1-已关闭，2-暂存)
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 关闭类型0-手动关闭,1-到期关闭
     */
    public Integer getCloseType() {
        return closeType;
    }

    /**
     * 关闭类型0-手动关闭,1-到期关闭
     */
    public void setCloseType(Integer closeType) {
        this.closeType = closeType;
    }
    /**
     * 关闭人
     */
    public Long getCloser() {
        return closer;
    }

    /**
     * 关闭人
     */
    public void setCloser(Long closer) {
        this.closer = closer;
    }
    /**
     * 求购说明
     */
    public String getNote() {
        return note;
    }

    /**
     * 求购说明
     */
    public void setNote(String note) {
        this.note = note;
    }
    /**
     * 详细地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    
}
