package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ImgdetailEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.business.panhuo.vo.LabeldetailVO;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.panhuo.mapper.WbuyMapper;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.IWbuyService;

import java.util.List;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
@Service("wbuyService")
public class WbuyServiceImpl extends BaseServiceImpl<WbuyMapper, WbuyEntity> implements IWbuyService{

    private static final String PANHUO_QG = "ASSET_DD";

    @Autowired
    private IBillCodeApi billCodeApi;

//    @Autowired
//    private IImgdetailService imgdetailService;

    @Autowired
    private ILabeldetailService labeldetailService;

    @Override
    public WbuyVO saveWbuy(WbuyVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WbuyEntity entity = BeanMapper.map(vo, WbuyEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_QG,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(null!=vo.getId()&&vo.getId() > 0){
            //修改
//            List<ImgdetailEntity> list = entity.getImgsPath();
            List<LabeldetailEntity> listlb = entity.getLabels();

//            entity.setMainimgPath(null);
//            QueryWrapper imgWrapper = new QueryWrapper();
//            imgWrapper.eq("source_id",vo.getId());
//            imgdetailService.remove(imgWrapper);

            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq("source_id",vo.getId());
            labeldetailService.remove(labekWrapper);

//            if(CollectionUtils.isNotEmpty(list)){
////                entity.setMainimgPath(list.get(0).getThumpath());
//                list.forEach(e -> {
//                    e.setId(null);
//                });
//            }

            if(CollectionUtils.isNotEmpty(listlb)){
                listlb.forEach(e -> {
                    e.setId(null);
                });
            }
        }
//        List<ImgdetailVO> list = vo.getImgsPath();
//        if(CollectionUtils.isNotEmpty(list)){
//            entity.setMainimgPath(list.get(0).getThumpath());
//        }
        entity.setBuyTime(DateFormater.getCurrentDate());
        super.saveOrUpdate(entity, false);
        WbuyVO resvo = BeanMapper.map(entity, WbuyVO.class);
        return resvo;
    }

    @Override
    public List<WbuyEntity> queryWbuy(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return baseMapper.getWbuy(pages,queryWrapper,lon,lat);
    }
}
