/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.util.IPUtils;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.maxmind.geoip2.DatabaseReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"goods"})
public class GoodsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService service;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @RequestMapping(value={"/publish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> publish(@RequestBody GoodsVO saveorUpdateVO) {
        return this.service.saveGoods(saveorUpdateVO);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdateTemp(@RequestBody GoodsVO saveorUpdateVO) {
        saveorUpdateVO.setStatus(Integer.valueOf(2));
        return this.service.saveGoods(saveorUpdateVO);
    }

    @RequestMapping(value={"/updateMainimgPath"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody GoodsVO saveorUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        updateWrapper.set(GoodsEntity::getMainimgPath, (Object)saveorUpdateVO.getMainimgPath());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setToolId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setRotatableNums(entity.getNums());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRotatableNums(entity.getNums());
        vo.setId(Long.valueOf(IdWorker.getId()));
        CommonResponse response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(id.toString(), "BT200813000000001", "imgUpload", vo.getId().toString(), "BT200813000000001", "imgUpload");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(OrderEntity::getGoodsId, (Object)vos.get(0).getId());
        List list = this.orderService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u5546\u54c1\u5b58\u5728\u8ba2\u5355,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(HttpServletRequest request, @RequestBody QueryParam param) throws Exception {
        String value;
        String[] split;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter dealrTime = (Parameter)param.getParams().get("shelfTime");
        if (dealrTime != null && dealrTime.getValue() != null && null != (split = (value = String.valueOf(dealrTime.getValue())).split(",")) && split.length == 2) {
            try {
                Calendar c = Calendar.getInstance();
                c.setTime(sdf.parse(split[1]));
                c.add(5, 1);
                Date date = c.getTime();
                String format = sdf.format(date);
                String newValue = split[0] + "," + format;
                dealrTime.setValue((Object)newValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(0);
        listStatus.add(3);
        param.getParams().put("status", new Parameter("in", listStatus));
        param.getParams().put("rotatableNums", new Parameter("gt", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        String lonValue = "";
        String LatValue = "";
        if (null != lon && null != lat) {
            lonValue = lon.getValue() + "";
            LatValue = lat.getValue() + "";
        } else {
            ClassPathResource resource = new ClassPathResource("GeoLite2-City_20210420/GeoLite2-City.mmdb");
            this.logger.info("-----" + resource);
            DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
            this.logger.info("******" + reader);
            String ip = IPUtils.getIP(request).split(",")[0];
            this.logger.info("******ip" + ip);
            if ("127.0.0.1".equals(ip)) {
                ip = "115.60.183.195";
            }
            lonValue = IPUtils.getLongitude(reader, ip).toString();
            LatValue = IPUtils.getLatitude(reader, ip).toString();
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<GoodsEntity> list = this.service.queryGoods(page, wrapper, lonValue, LatValue);
        res.put("records", (Object)BeanMapper.mapList(list, GoodsVO.class));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryGoodsDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryGoodsDetail(id));
    }

    @RequestMapping(value={"/queryOtherGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(0);
        param.getParams().put("status", new Parameter("in", listStatus));
        param.getParams().put("rotatableNums", new Parameter("gt", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put(key, new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter("in", childIds));
            }
        }
    }

    @RequestMapping(value={"/queryGoodsIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(0);
        param.getParams().put("status", new Parameter("in", listStatus));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsRecovery"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsRecovery(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(3);
        param.getParams().put("status", new Parameter("in", listStatus));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(1);
        listStatus.add(4);
        param.getParams().put("status", new Parameter("in", listStatus));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)2));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        this.setOrgParam("orgId", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter("eq", (Object)saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listOrder = this.orderService.queryList(queryParam, false);
        if (null != listOrder && listOrder.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8ba2\u5355,\u4e0d\u5141\u8bb8\u4e0b\u67b6\uff01");
        }
        entity.setStatus(1);
        entity.setLowerType(0);
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(entity.getSeller() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7269\u8d44\u4e0a\u67b6\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cr12g-panhuo-frontend/#/goodsManage/card?id=" + entity.getId();
        String mobileUrl = this.baseHost + "cr12g-panhuo-mobile/#/goodsManage/card?id=" + entity.getId();
        String subject = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u552e\u7f44\u5e76\u4e0b\u67b6";
        String content = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u552e\u7f44\u5e76\u4e0b\u67b6,<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        this.service.saveOrUpdate((Object)entity, false);
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/shelfGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        this.logger.debug("\u53c2\u6570----" + day);
        if (day > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, (Object)df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                HashMap map = new HashMap();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter("eq", (Object)entity.getId()));
                    queryParam.getParams().put("type", new Parameter("eq", (Object)0));
                    List listOrder = this.orderService.queryList(queryParam, false);
                    if (null == listOrder || listOrder.size() <= 0) {
                        this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u4e0b\u67b6----");
                        entity.setStatus(1);
                        entity.setLowerType(2);
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                        if (map.containsKey(entity.getSeller())) {
                            ((List)map.get(entity.getSeller())).add(entity);
                        } else {
                            ArrayList<GoodsEntity> listGoods = new ArrayList<GoodsEntity>();
                            listGoods.add((GoodsEntity)((Object)entity));
                            map.put(entity.getSeller(), listGoods);
                        }
                    }
                });
                for (Map.Entry entry : map.entrySet()) {
                    ArrayList<String> messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    ArrayList<String> sender = new ArrayList<String>();
                    sender.add(entry.getKey() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    String formurl = this.baseHost + "ejc-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=2&lowerTime=" + DateFormater.getInstance().format("yyyy-MM-dd");
                    String mobileUrl = this.baseHost + "ejc-panhuo-mobile/#/goodsManage?tab=1&userid={userid}";
                    String subject = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u4ef6\u4eca\u65e5\u5230\u671f\u81ea\u52a8\u4e0b\u67b6";
                    String content = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u4ef6\u4eca\u65e5\u5230\u671f\u81ea\u52a8\u4e0b\u67b6\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                    ArrayList<String> sender1 = new ArrayList<String>();
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7269\u8d44\u4e0a\u67b6\u4eba:>----------" + sender + this.baseHost);
                    ArrayList<String> sender2 = new ArrayList<String>();
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7269\u8d44\u90e8\u76f8\u5173\u6307\u5b9a\u56de\u6536\u4eba\u5458:>----------" + sender + this.baseHost);
                    for (GoodsEntity goodsEntity : (List)entry.getValue()) {
                        sender1.add(goodsEntity.getSellerName() + "");
                        String formurl1 = this.baseHost + "cr12g-panhuo-frontend/#/marketIndex/marketViewCard?id=" + goodsEntity.getId();
                        String mobileUrl1 = this.baseHost + "cr12g-panhuo-mobile/#/marketIndex/marketViewCard?id=" + goodsEntity.getId();
                        String subject1 = "\u3010" + goodsEntity.getAddressName() + "+" + goodsEntity.getMaterialName() + "\u3011\u4e0a\u67b6\u957f\u65f6\u95f4\u672a\u88ab\u8d2d\u4e70,\u5df2\u7ecf\u8fdb\u5165\u5f85\u56de\u6536\u72b6\u6001";
                        String content1 = "\u3010" + goodsEntity.getAddressName() + "+" + goodsEntity.getMaterialName() + "\u3011\u4e0a\u67b6\u957f\u65f6\u95f4\u672a\u88ab\u8d2d\u4e70,\u5df2\u7ecf\u8fdb\u5165\u5f85\u56de\u6536\u72b6\u6001,<a href=" + '\"' + formurl1 + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>";
                        this.sendMsg(messageType, sender1, "notice", subject1, content1, mobileUrl1);
                        sender2.add(goodsEntity.getName() + "");
                        String formurl2 = this.baseHost + "cr12g-panhuo-frontend/#/appoint/appointCard?id=" + goodsEntity.getId();
                        String mobileUrl2 = this.baseHost + "cr12g-panhuo-mobile/#/marketIndex/marketViewCard?id=" + goodsEntity.getId();
                        String subject2 = "\u3010" + goodsEntity.getAddressName() + "+" + goodsEntity.getMaterialName() + "\u3011\u4e0a\u67b6\u957f\u65f6\u95f4\u672a\u88ab\u8d2d\u4e70,\u8bf7\u6307\u5b9a\u5206\u516c\u53f8\u56de\u6536";
                        String content2 = "\u3010" + goodsEntity.getAddressName() + "+" + goodsEntity.getMaterialName() + "\u3011\u4e0a\u67b6\u957f\u65f6\u95f4\u672a\u88ab\u8d2d\u4e70,\u8bf7\u6307\u5b9a\u5206\u516c\u53f8\u56de\u6536,<a href=" + '\"' + formurl2 + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>";
                        this.sendMsg(messageType, sender2, "notice", subject2, content2, mobileUrl2);
                    }
                }
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    public static void main(String[] args) {
        Calendar calendar2 = Calendar.getInstance();
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        System.out.println();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String url) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)url);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @RequestMapping(value={"/orgStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportVO> orgStatistics(Long orgId) {
        ReportVO res = this.service.orgStatistics(orgId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/periodStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReportVO>> periodStatistics() {
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = this.service.periodStatistics(commonOrgIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/proportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReportVO>> proportion(int type) {
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = this.service.proportion(commonOrgIds, type);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/subordinateReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReportVO>> subordinateReport() {
        ArrayList res = new ArrayList();
        CommonResponse childrenOrg = this.orgApi.getDirectChildrenByPid(InvocationInfoProxy.getOrgId(), null);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)childrenOrg.getData()))) {
            ((List)childrenOrg.getData()).forEach(e -> {
                ReportVO vo = this.service.orgStatistics(e.getId());
                vo.setOrgName(e.getName());
                res.add(vo);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/updateGoodsStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse updateGoodsStatus(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        this.logger.debug("\u53c2\u6570----" + day);
        if (day >= 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, (Object)df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, (Object)0);
            lambdachange.eq(GoodsEntity::getAssetBelongType, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                HashMap map = new HashMap();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter("eq", (Object)entity.getId()));
                    queryParam.getParams().put("type", new Parameter("eq", (Object)0));
                    List listOrder = this.orderService.queryList(queryParam, false);
                    if (null == listOrder || listOrder.size() <= 0) {
                        this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u5f85\u6307\u5b9a----");
                        entity.setStatus(3);
                        entity.setRecoveryType(0);
                        listUp.add(entity);
                    }
                });
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/newGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse newGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        String role = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(1).getString("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + role + "----");
        if (day > 0) {
            String[] roles;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar1 = Calendar.getInstance();
            calendar.set(11, calendar.get(11) - day);
            calendar1.set(11, calendar.get(11) - 24);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String format = df.format(calendar.getTime());
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            this.logger.info(df.format(calendar1.getTime()) + "\u4e0a\u65b0\u521b\u5efa\u65f6\u95f4" + df.format(calendar.getTime()));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(GoodsEntity::getStatus, (Object)0)).lt(BaseEntity::getCreateTime, (Object)df.format(calendar.getTime()))).gt(BaseEntity::getCreateTime, (Object)df.format(calendar1.getTime()));
            List list = this.service.list((Wrapper)wrapper);
            for (String s : roles = role.split(",")) {
                ArrayList<String> messageType = new ArrayList<String>();
                messageType.add("sys");
                messageType.add("weChat");
                ArrayList<String> sender = new ArrayList<String>();
                sender.add(s + "");
                this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u9879\u76ee\u7269\u8d44\u8d1f\u8d23\u4eba:>----------" + s + this.baseHost);
                String formurl = this.baseHost + "cr12g-panhuo-frontend/#/marketIndex";
                String mobileUrl = this.baseHost + "cr12g-panhuo-mobile/#/marketIndex";
                String subject = "\u95f2\u7f6e\u8d44\u6e90\u5e93\u6628\u65e5\u65b0\u589e\u3010" + list.size() + "\u3011\u4e2a\u7269\u8d44";
                String content = "\u95f2\u7f6e\u8d44\u6e90\u5e93\u6628\u65e5\u65b0\u589e\u95f2\u7f6e\u8d44\u6e90\u5e93\u6628\u65e5\u65b0\u589e\u3010" + list.size() + "\u3011\u4e2a\u7269\u8d44,\u8bf7\u5173\u6ce8\u3002<a href=" + '\"' + formurl + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>";
                this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }
}

