package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.ejianc.business.asset.bean.*;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.vo.CheckDetailVO;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.vo.CheckVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 验收实体
 *
 * @author generator
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAllotService allotService;

    @Autowired
    private IPlanService planService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @Description saveOrUpdate 调拨验收附件复制
     */
    @RequestMapping(value = "/copyCheckFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> copyCheckFile(Long goodsId) {
        return service.copyCheckFile(goodsId);
    }




    /**
     * @param id
     * @Description queryDetail 查询计划组装验收数据
     */
    @RequestMapping(value = "/queryPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryPlan(Long id) {
        PlanEntity planEntity = planService.selectById(id);
        CheckVO vo = new CheckVO();
        vo.setCheckDate(new Date());
        vo.setOrgId(planEntity.getOrgId());
        vo.setOrgName(planEntity.getOrgName());
        vo.setPlanId(id);
        vo.setBelongType(0);
        vo.setCheckType(0);
        vo.setProjectId(planEntity.getProjectId());
        vo.setProjectName(planEntity.getProjectName());
        vo.setEngineeringType(planEntity.getEngineeringType());
        vo.setEngineeringTypeName(planEntity.getEngineeringTypeName());
        vo.setParentOrgId(planEntity.getParentOrgId());
        vo.setParentOrgName(planEntity.getParentOrgName());
        List<CheckDetailVO> list = new ArrayList<>();
        List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
        if (CollectionUtils.isNotEmpty(planDetail)) {
            for (PlanDetailEntity p : planDetail) {
                CheckDetailVO v = new CheckDetailVO();
                v.setId(p.getId());
                v.setAssetType(p.getAssetType());
                v.setAssetCode(null);
                v.setAssetId(null);
                v.setMaterialTypeId(p.getMaterialTypeId());
                v.setMaterialTypeCode(p.getMaterialTypeCode());
                v.setMaterialTypeName(p.getMaterialTypeName());
                v.setMaterialId(p.getMaterialId());
                v.setMaterialCode(p.getMaterialCode());
                v.setMaterialName(p.getMaterialName());
                v.setUnit(p.getUnit());
                v.setSpec(p.getSpec());
                v.setPlanNum(p.getNums());
                v.setSumNum(p.getSumNums());
                v.setAssetBelongType(0);//归属于项目
                v.setCheckNum(p.getAssetType() ==0 ? null : BigDecimal.ONE);
                v.setRowState("add");
                BigDecimal sumNums = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                if (sumNums.compareTo(p.getNums()) < 0) {
                    list.add(v);
                }
            }

            vo.setCheckDetail(list);
        }
        //拷贝附件
        CommonResponse<CheckVO> checkVOCommonResponse = service.copyPlanFile(id, vo);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
        CheckEntity entity = service.selectById(id);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        List<Long> idlist = vos.stream().map(CheckVO::getId).collect(Collectors.toList());
        for (Long id : idlist) {
            CheckEntity entity = service.selectById(id);
            if (null != entity.getAllotId() && 0 != entity.getAllotId()) {
                AllotEntity allotEntity = allotService.selectById(entity.getAllotId());
                allotEntity.setState(0);
                allotService.updateById(allotEntity);
            }
            if (null != entity.getPlanId()) {
                PlanEntity planEntity = planService.selectById(entity.getPlanId());
                List<CheckDetailEntity> detail = entity.getCheckDetail();
                List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
                if (CollectionUtils.isNotEmpty(detail) && CollectionUtils.isNotEmpty(planDetail)) {
                    Map<Long, CheckDetailEntity> numMap =
                            detail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));

                    for (PlanDetailEntity p : planDetail) {
                        Long materialId = p.getMaterialId();
                        CheckDetailEntity dec = numMap.get(materialId);
                        if (dec != null) {
                            p.setSumNums(p.getSumNums().subtract(dec.getCheckNum()));
                        }
                    }
                    //删除是减项，绝对是验收未完成
                    planEntity.setCheckState(0);
                    planService.saveOrUpdate(planEntity, false);
                }
            }
        }

        service.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @param param
     * @Description queryList 查询列表-项目
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));
        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 查询列表-公司
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOrgList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryOrgList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));
        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<CheckEntity> pageData = service.queryPage(param, false);
        List<CheckVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getCheckType() == 0) {
                    vo.setCheckTypeName("项目自采");
                } else {
                    vo.setCheckTypeName("内部调拨");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }


    @RequestMapping(value = "/excelOrgExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelOrgExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<CheckEntity> pageData = service.queryPage(param, false);
        List<CheckVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getCheckType() == 0) {
                    vo.setCheckTypeName("项目自采");
                } else {
                    vo.setCheckTypeName("内部调拨");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkOrgExport.xlsx", beans, response);
    }

}
