package com.ejianc.business.panhuo.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
public interface IGoodsService extends IBaseService<GoodsEntity> {

    CommonResponse<GoodsVO> saveGoods(GoodsVO vo);

    CommonResponse<GoodsVO> saveGoodsTemp(GoodsVO vo);

    GoodsDetailsVO queryGoodsDetail(Long id);

    List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper,String lon,String lat);

    ReportVO orgStatistics(Long orgId);

    List<ReportVO> periodStatistics(List<Long> commonOrgIds);

    List<ReportVO> proportion(List<Long> commonOrgIds,int type);

    List<GoodsVO> selectDetail(Long projectId,Long orgId, String materialName);

    List<GoodsVO> selectRecover(Long projectId, Long orgId, String materialName);

}
