package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PANHUO_DD = "ASSET_DD";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IAllotService allotService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public OrderVO saveOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        if(goodsEntity.getVersion()!=vo.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
        BigDecimal ordernums = vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums();
        if(ordernums.compareTo(rotatableNums)>0){
            throw new BusinessException("下单数量不能超过资产可周转数量!");
        }

        OrderEntity orderEntity = BeanMapper.map(vo,OrderEntity.class);
//        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setAssetCode(goodsEntity.getAssetCode());
        orderEntity.setAssetId(goodsEntity.getAssetId());
        if(1==vo.getOrderType()){
            //租赁下单，归属方为公司
            orderEntity.setAssetBelongType(1);
            orderEntity.setBelongOrgId(goodsEntity.getBelongOrgId());
            orderEntity.setBelongOrgName(goodsEntity.getBelongOrgName());
        }else{
            orderEntity.setAssetBelongType(0);
        }
        orderEntity.setCapacity(goodsEntity.getCapacity());
        orderEntity.setAssetType(goodsEntity.getAssetType());
        orderEntity.setBelongType(goodsEntity.getBelongType());//出售方类型
        orderEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());//新增订单为自由态
        orderEntity.setMaterialTypeCode(goodsEntity.getMaterialTypeCode());
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);//待确认
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny()==null?BigDecimal.ZERO:vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice()==null?BigDecimal.ZERO:vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        if(null!=vo&&StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_DD,tenantId);
            if(billCode.isSuccess()) {
                orderEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        BigDecimal nums = goodsEntity.getNums()==null?BigDecimal.ZERO:goodsEntity.getNums();
//        BigDecimal sellNums = goodsEntity.getSellNums()==null?BigDecimal.ZERO:goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
        goodsEntity.setPreNums(preNums.add(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.subtract(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums()));
        goodsService.saveOrUpdate(goodsEntity,false);

        super.saveOrUpdate(orderEntity, false);



        //TO DO 订单提交消息发送
//        List<String> messageType = new ArrayList<>();
//        messageType.add("sys");//pc
//        messageType.add("weChat");//移动
//        List<String> sender = new ArrayList<>();
//        sender.add(goodsEntity.getSellerName()+"");
//        logger.info("发送信息给物资部审批人:>----------" + sender + baseHost);
//        String formurl = baseHost + "cr12g-panhuo-frontend/#/order?id="+goodsEntity.getId();
//        String mobileUrl = baseHost + "cr12g-panhuo-mobile/#/approvePages/order?id="+goodsEntity.getId();
//        String subject = "您有一个新的流程需要您审批";
//        String content = "您有一个新的流程【" + goodsEntity.getProjectName()+"+"+goodsEntity.getBillCode() + "】需要您审批，<a href=" + '"' + formurl + '"' + ">点击查看</a>";
//        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);



        /*//购买方确认订单后后发送消息给售方确认
        List<String> messageType2=new ArrayList<>();
        messageType2.add("sys");
        messageType2.add("weChat");
        List<String> sender2=new ArrayList<>();
        sender2.add(orderEntity.getSeller()+"");
        logger.info("发送消息给物资上架人:>----------"+sender2);
        String formurl2 = baseHost+"ejc-panhuo-frontend/#/buyOrder/card?id="+orderEntity.getId();
        String mobileUrl2 = baseHost+"ejc-panhuo-mobile/#/buyOrder/card?id="+orderEntity.getId();
        String subject2 = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理";
        String content2 = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理。<a href=" + '"' + formurl2 + '"' + ">前往点击</a>";
        this.sendMsg(messageType2,sender2,"notice",subject2,content2,mobileUrl2);
*/


        OrderVO resvo = BeanMapper.map(orderEntity, OrderVO.class);
        return resvo;
    }

    @Override
    public String confirmerOrder(OrderVO vo) {
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        OrderEntity orderEntity = super.getById(vo.getId());
        if(orderEntity.getVersion()!=vo.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        BigDecimal nums = goodsEntity.getNums()==null?BigDecimal.ZERO:goodsEntity.getNums();
        BigDecimal sellNums = goodsEntity.getSellNums()==null?BigDecimal.ZERO:goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
        BigDecimal remainingNums = goodsEntity.getRemainingNums()==null?BigDecimal.ZERO:goodsEntity.getRemainingNums();//剩余

        goodsEntity.setSellNums(sellNums.add(vo.getNums()));//已成交
        goodsEntity.setPreNums(preNums.subtract(orderEntity.getOrdernums()));//预定中
        goodsEntity.setRotatableNums(nums.subtract(goodsEntity.getSellNums()).subtract(goodsEntity.getPreNums()));//可周转
        goodsEntity.setRemainingNums(nums.subtract(goodsEntity.getSellNums()));//剩余数量
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,vo.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,vo.getId());
            int num = super.count(lambdachange);
            if(num<=0){
                // TO DO 下架消息发送
                List<String> messageType = new ArrayList<>();
                messageType.add("sys");
                messageType.add("weChat");
                List<String> sender = new ArrayList<>();
                sender.add(goodsEntity.getSeller()+"");
                logger.info("发送信息给提交人:>----------" + sender);
                String formurl = baseHost+"cr12g-panhuo-frontend/#/shelfManagement/details?id="+goodsEntity.getId();
                String mobileUrl = baseHost+"cr12g-panhuo-mobile/#/goodsManage/card?id="+goodsEntity.getId()+"&userid={userid}";
                String subject = "您上架的物资【"+goodsEntity.getMaterialName()+"】已经售罄并下架";
                String content = "您上架的物资【"+goodsEntity.getMaterialName()+"】已经售罄并下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }
        }

        /*// TO DO 确认订单消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(orderEntity.getOrderUserId()+"");//订购人
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=2";
        String mobileUrl = baseHost+"ejc-panhuo-mobile/#/buyOrder/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成";
        String content = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);*/


        // 卖方接收到订单,确认后 发消息给买方
        List<String> messageType2 = new ArrayList<>();
        messageType2.add("sys");
        messageType2.add("weChat");
        List<String> orderUserId = new ArrayList<>();
        orderUserId.add(orderEntity.getOrderUserId()+"");//订购人
        logger.info("发送信息给提交人:>----------" + orderUserId);
        String formurl2 = baseHost+"cr12g-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId();
        String mobileUrl2 = baseHost+"cr12g-panhuo-mobile/#/buyOrder/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject2 = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成";
        String content2 = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成。<a href=" + '"' + formurl2 + '"' + ">前往点击</a>";
        this.sendMsg(messageType2, orderUserId, "notice", subject2, content2,mobileUrl2);


        goodsService.saveOrUpdate(goodsEntity,false);
        orderEntity.setConfirmer(vo.getConfirmer());
        orderEntity.setConfirmName(vo.getConfirmName());
        orderEntity.setPrice(vo.getPrice());
        orderEntity.setNums(vo.getNums());
        orderEntity.setMny(vo.getMny());
        orderEntity.setDealrTime(DateFormater.getCurrentDate());
        orderEntity.setType(1);//订单完成
        super.saveOrUpdate(orderEntity, false);

        //生成调拨单
        AllotVO allotVO = BeanMapper.map(orderEntity, AllotVO.class);
        allotVO.setId(null);
        allotVO.setBillCode(null);
        allotVO.setOrderId(orderEntity.getId());
        allotVO.setAmount(orderEntity.getMny());
        allotVO.setConfirmerName(orderEntity.getConfirmName());
        allotVO.setBillState(1);
        allotVO.setState(0);
        allotService.saveAllot(allotVO);

        //将商品的资产图片复制到调拨单
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(goodsEntity.getId()), "BT210510000000005", "imgUpload",
                String.valueOf(allotVO.getId()), "BT210510000000002", "imgUpload");

        return "success";
    }

    @Override
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
        logger.info("发送消息开始！===========");
        logger.info("移动端地址消息发送地址==========="+url);
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", url);
            weixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
