package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.StordocHystrix;
import com.ejianc.business.dataexchange.vo.Stordoc;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 仓库参照接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = StordocHystrix.class)
public interface IStordocApi {

	/**
	 * 仓库参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/queryStordocRef")
	public CommonResponse<IPage<Stordoc>> queryStordocRef(
            @RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText
	);

}
