package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.NcUserHystrix;
import com.ejianc.business.dataexchange.vo.CorpUser;
import com.ejianc.business.dataexchange.vo.User;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC用户接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = NcUserHystrix.class)
public interface IUserApi {



	/**
	 * NC用户同步查询（含用户默认项目）
	 * @return
	 */
	@GetMapping(value = "/api/user/list")
	public CommonResponse<List<User>> queryUsersByTs(@RequestParam(required = true) String ts);

	/**
	 * NC用户同步查询（含用户默认项目）(区间)
	 * @return
	 */
	@GetMapping(value = "/api/user/listByQj")
	public CommonResponse<List<User>> queryUsersByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime);

	/**
	 * NC用户组织权限同步查询
	 * @return
	 */
	@GetMapping(value = "/api/corpuser/list")
	public CommonResponse<List<CorpUser>> queryCorpUserByTs(@RequestParam(required = true) String ts);

	/**
	 * NC用户组织权限同步查询(区间)
	 * @return
	 */
	@GetMapping(value = "/api/corpuser/listByQj")
	public CommonResponse<List<CorpUser>> queryCorpUserByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
															@RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow);
}
