package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CorpDeptPathHystrix;
import com.ejianc.business.dataexchange.vo.Project;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC项目接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CorpDeptPathHystrix.class)
public interface ICorpDeptPathApi {



	/**
	 * 项目在NC部门档案中的组织路径
	 * @return
	 */
	@GetMapping(value = "/api/corpdept/path")
	public CommonResponse<String> queryProjectPath(@RequestParam(required = false) String projectcode,
                                                          @RequestParam(required = false) String projectname);



}
