package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.InvHystrix;
import com.ejianc.business.dataexchange.vo.Invbas;
import com.ejianc.business.dataexchange.vo.Invcl;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC物料接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = InvHystrix.class)
public interface IInvApi {



	/**
	 * NC物料类别同步查询
	 * @return
	 */
	@GetMapping(value = "/api/invcl/list")
	public CommonResponse<List<Invcl>> queryNCInvclByTs(@RequestParam(required = true) String ts);


	/**
	 * NC物料基本档案同步查询
	 * @return
	 */
	@GetMapping(value = "/api/invbas/list")
	public CommonResponse<List<Invbas>> queryNCInvbasByTs(@RequestParam(required = true) String ts);

	/**
	 * NC物料基本档案同步查询(区间)
	 * @return
	 */
	@GetMapping(value = "/api/invbas/listByQj")
	public CommonResponse<List<Invbas>> queryNCInvbasByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
														  @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow);

	/**
	 * NC物料管理档案同步查询
	 * @return
	 */
	@GetMapping(value = "/api/invman/list")
	public CommonResponse<List<Invman>> queryNCInvmanByTs(@RequestParam(required = true) String ts,
														  @RequestParam(required = false) String pkCorp);

	/**
	 * NC物料管理档案同步查询(区间)
	 * @return
	 */
	@GetMapping(value = "/api/invman/listByQj")
	public CommonResponse<List<Invman>> queryNCInvmanByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
														  @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow,
														  @RequestParam(required = false) String pkCorp);

	/**
	 * NC物料管理档案同步，放redis里
	 * @return
	 */
	@GetMapping(value = "/api/invman/redisByOrgList")
	CommonResponse<String> redisByOrgList(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime, @RequestParam(required = false) String tenantId, @RequestParam(required = false) String pkCorp);
}
