package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.CmContractHystrix;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 五局合同接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CmContractHystrix.class)
public interface ICmContractApi {

	/**
	 * 物资合同参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/queryMatContractRef")
	public CommonResponse<IPage<CmContract>> queryMatContractRef(
            @RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 分包合同参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/querySubContractRef")
	public CommonResponse<IPage<CmContract>> querySubContractRef(
			@RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 分包、物资、设备合同参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/queryContractRef")
	public CommonResponse<IPage<CmContract>> queryContractRef(
			@RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

	@GetMapping(value = "/api/queryMatContractById")
	public CommonResponse<CmContract> queryMatContractById(
			@RequestParam(value = "contractId") String contractId
		);

	/**
	 * 分包合同参照查询
	 * @param pkCorp	公司
	 * @return
	 */
	@GetMapping(value = "/api/querySubContractByCorp")
	public CommonResponse<IPage<CmContract>> querySubContractByCorp(
			@RequestParam(value = "pkCorp", required = false) String pkCorp,
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

}
