package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.CtplanHystrix;
import com.ejianc.business.dataexchange.vo.Ctplan;
import com.ejianc.business.dataexchange.vo.CtplanB;
import com.ejianc.business.dataexchange.vo.CtplanCtrVO;
import com.ejianc.business.dataexchange.vo.CtplanCtrlQueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * NC消耗材总控计划接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = CtplanHystrix.class)
public interface ICtplanApi {



	/**
	 * NC总控表头同步查询
	 * @return
	 */
	@GetMapping(value = "/api/ctplan/list")
	 CommonResponse<List<Ctplan>> queryNCCtPlanlByTs(@RequestParam(required = true, value = "ts") String ts);


	/**
	 * NC总控表体同步查询
	 * @return
	 */
	@GetMapping(value = "/api/ctplan/detailList")
	 CommonResponse<List<CtplanB>> queryNCCtPlanDetailByTs(@RequestParam(required = true, value = "ts") String ts);

	/**
	 * NC总控控制信息查询
	 * @return
	 */
	@RequestMapping(value = "/api/ctplan/queryNCCtPlanCtrl", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<List<CtplanCtrVO>> queryNCCtPlanCtrl(@RequestBody CtplanCtrlQueryVO queryVO);

}
