package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.MeasdocHystrix;
import com.ejianc.business.dataexchange.vo.MeasdocVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 计量档案参照接口
 * 
 * @author
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = MeasdocHystrix.class)
public interface IMeasdocApi {

	/**
	 * 计量档案参照查询
	 * @return
	 */
	@GetMapping(value = "/api/queryMeasdocRef")
	public CommonResponse<IPage<MeasdocVO>> queryMeasdocRef(
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText);

}
