package com.ejianc.business.dataexchange.vo;


import java.math.BigDecimal;

/**
 * 合同Info vo
 * @author sunq
 * @since 2020-11-08 08:02:02
 */
public class CmContractInfoVO {

    private static final long serialVersionUID = 1L;

    /**
     *  物资在轻量化 相关信息
     */
    private Long materialId;               // 物资明细轻量化Id
    private String materialCode;               // 物资明细编码
    private Long materialTypeId;          // 物资类别轻量化Id
    private String materialTypeName;      // 物资类别名称
    private String materialTypeInnerCode;      // 物资类别内码

    /**
     *  NC合同清单基本信息
     */
    private String pkContractinfo;
    private String pkContract;
    private String infocode;
    private String infoname;
    private String name;
    private String spec;
    private String vmemo;

    /**
     *  NC 合同分录基本信息
     */
    private String pkAmountlist;
    private String amountcode;
    private String amountname;
    private BigDecimal sl;

    /**
     *  NC 合同清单度量单位信息（注：度量单位，如米、元、吨）
     */
    private String infounit;             // 合同单位名称（注：度量单位，如米、元、吨）
    private String pkContmeasdoc;       // 合同单位主键
    private String contScale;           // 合同单位 转换系数
    private String pkMngmeasdoc;       // 管理单位主键
    private String mngunitname;        // 管理单位名称
    private String mngScale;           // 管理单位 转换系数

    /**
     *  NC 分包合同清单 指标信息
     */
    private String infoamount;          // 分包合同 清单数量
    private double infoprice;          // 分包合同 清单单价
    private double infoSumNum;         // 分包合同 清单累积量  By zhangwx 2021-12-3

    /**
     *  NC 周转材租赁合同清单 指标信息     ==> 用于根据合同主键查询租赁清单信息
     */
    private String pkInvcl;          // NC物资分类PK
    private String pkInvbasdoc;      // NC物资明细PK
    private double infonum;          // 合同数量
    private double hireprice;        // 租赁单价（无税）
    private double taxhireprice;    // 租赁单价（含税）
    private double wasteprice;      // 报损赔偿单价（无税）
    private double taxwasteprice;   // 报损赔偿单价（含税）
    private String dplanoutdate;     // 计划出厂日期
    private String dplanindate;      // 计划到场日期

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialTypeInnerCode() {
        return materialTypeInnerCode;
    }

    public void setMaterialTypeInnerCode(String materialTypeInnerCode) {
        this.materialTypeInnerCode = materialTypeInnerCode;
    }

    public String getPkContractinfo() {
        return pkContractinfo;
    }

    public void setPkContractinfo(String pkContractinfo) {
        this.pkContractinfo = pkContractinfo;
    }

    public String getPkContract() {
        return pkContract;
    }

    public void setPkContract(String pkContract) {
        this.pkContract = pkContract;
    }

    public String getInfocode() {
        return infocode;
    }

    public void setInfocode(String infocode) {
        this.infocode = infocode;
    }

    public String getInfoname() {
        return infoname;
    }

    public void setInfoname(String infoname) {
        this.infoname = infoname;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getVmemo() {
        return vmemo;
    }

    public void setVmemo(String vmemo) {
        this.vmemo = vmemo;
    }

    public String getPkAmountlist() {
        return pkAmountlist;
    }

    public void setPkAmountlist(String pkAmountlist) {
        this.pkAmountlist = pkAmountlist;
    }

    public String getAmountcode() {
        return amountcode;
    }

    public void setAmountcode(String amountcode) {
        this.amountcode = amountcode;
    }

    public String getAmountname() {
        return amountname;
    }

    public void setAmountname(String amountname) {
        this.amountname = amountname;
    }

    public BigDecimal getSl() {
        return sl;
    }

    public void setSl(BigDecimal sl) {
        this.sl = sl;
    }

    public String getInfounit() {
        return infounit;
    }

    public void setInfounit(String infounit) {
        this.infounit = infounit;
    }

    /**
     *  新增合同单位主键、管理单位主键、管理单位名称（注：单位为度量单位，如米、元、吨）
     * @return
     */
    public String getPkContmeasdoc() {
        return pkContmeasdoc;
    }

    public void setPkContmeasdoc(String pkContmeasdoc) {
        this.pkContmeasdoc = pkContmeasdoc;
    }

    public String getContScale() {
        return contScale;
    }

    public void setContScale(String contScale) {
        this.contScale = contScale;
    }

    public String getPkMngmeasdoc() {
        return pkMngmeasdoc;
    }

    public void setPkMngmeasdoc(String pkMngmeasdoc) {
        this.pkMngmeasdoc = pkMngmeasdoc;
    }

    public String getMngunitname() {
        return mngunitname;
    }

    public void setMngunitname(String mngunitname) {
        this.mngunitname = mngunitname;
    }

    public String getMngScale() {
        return mngScale;
    }

    public void setMngScale(String mngScale) {
        this.mngScale = mngScale;
    }

    public String getInfoamount() {
        return infoamount;
    }

    public void setInfoamount(String infoamount) {
        this.infoamount = infoamount;
    }

    public double getInfoprice() {
        return infoprice;
    }

    public void setInfoprice(double infoprice) {
        this.infoprice = infoprice;
    }

    public double getInfoSumNum() {
        return infoSumNum;
    }

    public void setInfoSumNum(double infoSumNum) {
        this.infoSumNum = infoSumNum;
    }

    public String getPkInvcl() {
        return pkInvcl;
    }

    public void setPkInvcl(String pkInvcl) {
        this.pkInvcl = pkInvcl;
    }

    public String getPkInvbasdoc() {
        return pkInvbasdoc;
    }

    public void setPkInvbasdoc(String pkInvbasdoc) {
        this.pkInvbasdoc = pkInvbasdoc;
    }

    public double getInfonum() {
        return infonum;
    }

    public void setInfonum(double infonum) {
        this.infonum = infonum;
    }

    public double getHireprice() {
        return hireprice;
    }

    public void setHireprice(double hireprice) {
        this.hireprice = hireprice;
    }

    public double getTaxhireprice() {
        return taxhireprice;
    }

    public void setTaxhireprice(double taxhireprice) {
        this.taxhireprice = taxhireprice;
    }

    public double getWasteprice() {
        return wasteprice;
    }

    public void setWasteprice(double wasteprice) {
        this.wasteprice = wasteprice;
    }

    public double getTaxwasteprice() {
        return taxwasteprice;
    }

    public void setTaxwasteprice(double taxwasteprice) {
        this.taxwasteprice = taxwasteprice;
    }

    public String getDplanoutdate() {
        return dplanoutdate;
    }

    public void setDplanoutdate(String dplanoutdate) {
        this.dplanoutdate = dplanoutdate;
    }

    public String getDplanindate() {
        return dplanindate;
    }

    public void setDplanindate(String dplanindate) {
        this.dplanindate = dplanindate;
    }
}


