package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.service.ICorpTreeService;
import com.ejianc.business.dataexchange.vo.CorpTreeVO;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 公司树参照
 */
@RestController
@RequestMapping("corptree")
public class CorpTreeController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICorpTreeService corpTreeService;


    @RequestMapping(value = "queryNCCorpRef", method= RequestMethod.GET)
    @ResponseBody
    public List<CorpTreeVO> queryNCCorpRef(
            @RequestParam(required = false) String pid,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        //InvocationInfoProxy.getUserid();

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
//        queryParam.setPageIndex(pageNumber);
//        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");

        if("@@@@".equals(pid)) {
            pid = null;
        }

        /** 租户隔离 */
        Long supplierId = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
        }


        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<CorpTreeVO> listres = corpTreeService.queryNCCoprTreeList(wrapper,pid);
        for (CorpTreeVO c : listres
             ) {
            if(c.getPid() == null)
                c.setPid("@");
        }
        return buildTree(listres);
    }

    //构建公司树
    public List<CorpTreeVO> buildTree(List<CorpTreeVO> pidList){
        Map<String,List<CorpTreeVO>> pidListMap =
                pidList.stream().collect(Collectors.groupingBy(CorpTreeVO::getPid));
        pidList.stream().forEach(item->item.setChildren(pidListMap.get(item.getId())));
      //  System.out.println(JSON.toJSONString(pidListMap.get("@")));
        //返回顶层节点的list
        return pidListMap.get("@");
    }
}
