package com.ejianc.business.dataexchange.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CorpDeptPathMapper;
import com.ejianc.business.dataexchange.service.ICorpDeptPathService;
import com.ejianc.business.dataexchange.service.ICorpTreeService;
import com.ejianc.business.dataexchange.vo.CorpDeptPath;
import com.ejianc.business.dataexchange.vo.CorpTreeVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 * 项目组织路径 服务实现类
 * </p>
 *
 * @author Brin
 * @since 2020-12-21 17:15:55
 */
@Service("orpDeptPathService")
public class CorpDeptPathService extends ServiceImpl<CorpDeptPathMapper, CorpDeptPath> implements ICorpDeptPathService {

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private ICorpTreeService corpTreeService;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public String selectProjectFilePath(QueryWrapper queryWrapper,String deptcode, String deptname) {
        String path = null;

        //获取redis中的Path，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取String类型的path  ------------");

        if(deptcode != null &&  redisTemplate.opsForHash().hasKey("COPR-DEPT-PATH-N",deptcode) ) {
            path = (String) redisTemplate.opsForHash().get("COPR-DEPT-PATH-N",deptcode);
            logger.info("------------  redisTemplate里有key为deptcode的path ,path: ------------"+path);
            return path;
        }
        if(deptname != null && redisTemplate.opsForHash().hasKey("COPR-DEPT-PATH-N",deptname)) {
            path = (String) redisTemplate.opsForHash().get("COPR-DEPT-PATH-N",deptname);
            logger.info("------------  redisTemplate里有key为deptname的path ,path: ------------"+path);
            return path;
        }



        //拿到list
        List<CorpDeptPath> list = getCorpDeptList(queryWrapper);
        //按照项目编码或者名称找到叶子节点项目信息
        List<CorpDeptPath> ps =  list.stream().filter(cdp -> cdp.getDeptcode() != null && deptcode != null && cdp.getDeptcode().equals(deptcode)
                                                   || cdp.getDeptname() != null && deptname != null && cdp.getDeptname().equals(deptname))
                                              .collect(Collectors.toList());

        if(ps != null && !ps.isEmpty()) {
            CorpDeptPath cdp = ps.get(0);
            path = "/" + cdp.getDeptname();
            String deptpath = findDeptPath(list, path, cdp.getPkFathedept());
            String cpath = "/" + cdp.getUnitname();

            List<CorpTreeVO> cts = getCorpList();//corpTreeService.queryNCCoprTreeList();
            String corppath = findCorpPath(cts, cpath, cdp.getFathercorp());

            path = corppath + deptpath;
        }

        //存储path到redis中
        if(deptcode != null && path != null){
            logger.info("------------  redisTemplate里设置key为deptcode的path ,path: ------------"+path);
            redisTemplate.opsForHash().put("COPR-DEPT-PATH-N",deptcode,path);
        }
        if(deptname != null && path != null) {
            logger.info("------------  redisTemplate里设置key为deptname的path ,path: ------------"+path);
            redisTemplate.opsForHash().put("COPR-DEPT-PATH-N",deptname,path);
        }

        return path;
    }

    /**
     * 拼出公司路径
     * @param list
     * @param cpath
     * @param fathercorp
     * @return
     */
    private String findCorpPath(List<CorpTreeVO> list, String cpath,  String fathercorp) {
        if(fathercorp == null) {
            return cpath;
        }
        List<CorpTreeVO> ps =  list.stream().filter(cdp -> cdp.getId().equals(fathercorp))
                .collect(Collectors.toList());
        if(ps != null && !ps.isEmpty()) {
            CorpTreeVO cdp = ps.get(0);
            cpath = "/" + cdp.getName() + cpath;
            logger.info("------------  获取开始获取corp路径服务，请求成功！cpath: " + cpath + "  ------------");

            return findCorpPath(list, cpath, cdp.getPid());
        } else {
            return cpath;
        }

    }

    /**
     * 拼出部门路径
     * @param list
     * @param path
     * @param pkFathedept
     * @return
     */
    private String findDeptPath(List<CorpDeptPath> list, String path,  String pkFathedept) {
        if(pkFathedept == null) {
            return path;
        }
        List<CorpDeptPath> ps =  list.stream().filter(cdp -> cdp.getPkDeptdoc().equals(pkFathedept))
                .collect(Collectors.toList());
        if(ps != null && !ps.isEmpty()) {
            CorpDeptPath cdp = ps.get(0);
            path = "/" + cdp.getDeptname() + path;
            logger.info("------------  获取开始获取dept路径服务，请求成功！path: " + path + "  ------------");

            return findDeptPath(list, path, cdp.getPkFathedept());
        } else {
            return path;
        }

    }

    /**
     * 获取公司列表
     * @return
     */
    private List<CorpTreeVO> getCorpList() {
        List<CorpTreeVO> list = null;
        //获取redis中的CorpList，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取CorpList  ------------");
        if(redisTemplate.opsForValue().get("CORP-LIST-N") != null){
            list = (List<CorpTreeVO>) redisTemplate.opsForValue().get("CORP-LIST-N");
            logger.info("------------  redisTemplate里有CorpList ,size: ------------"+list.size());
        } else {
            logger.info("------------  开始获取CorpList服务，请求成功！size: " + list.size() + "  ------------");
            list = corpTreeService.queryNCCoprTreeList();
            if(list != null) {
                redisTemplate.opsForValue().set("CORP-LIST-N", list, 86400, TimeUnit.SECONDS);
            }
        }
        return list;

    }

    private List<CorpDeptPath> getCorpDeptList(QueryWrapper queryWrapper) {
        List<CorpDeptPath> list = null;
        //获取redis中的CorpDeptPathList，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取CorpDeptPathList  ------------");
        if(redisTemplate.opsForValue().get("CORP-DEPT-LIST-N") != null){
//        long size = redisTemplate.opsForList().size("CORP-DEPT-LIST");
//        if(size> 0){

            list = (List<CorpDeptPath>) redisTemplate.opsForValue().get("CORP-DEPT-LIST-N");
//            List l = redisTemplate.opsForList().range("CORP-DEPT-LIST",0,-1);
//            list = (List<CorpDeptPath>)l;
            logger.info("------------  redisTemplate里有CorpDeptPathList ,size: ------------"+list.size());
        }else{
            logger.info("------------  开始获取CorpDeptPathList服务，请求成功！size: " + list.size() + "  ------------");
            list = baseMapper.selectListAll(queryWrapper);
            //将获取到的CorpDeptPath List放入redis中
//            redisTemplate.opsForList().rightPushAll("CORP-DEPT-LIST",list);
            if(list != null) {
                redisTemplate.opsForValue().set("CORP-DEPT-LIST-N", list,86400, TimeUnit.SECONDS);
            }

        }

        return list;
    }
}
    

