package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.ITtplanBService;
import com.ejianc.business.dataexchange.service.ITtplanService;
import com.ejianc.business.dataexchange.vo.Ttplan;
import com.ejianc.business.dataexchange.vo.TtplanB;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class TtplanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ITtplanService ttplanService;

    @Autowired
    private ITtplanBService ttplanBService;

    /**
     * NC总控表头同步查询
     * @return
     */
    @GetMapping(value = "/ttplan/list")
    public CommonResponse<List<Ttplan>> queryNCTtPlanlByTs(@RequestParam(required = true) String ts) {
        List<Ttplan> ttplans = ttplanService.queryNCTtPlanlByTs(ts);
        return CommonResponse.success("查询物料分类同步数据成功！", ttplans);
    }

    /**
     * NC总控表体同步查询
     * @return
     */
    @GetMapping(value = "/ttplan/detailList")
    public CommonResponse<List<TtplanB>> queryNCTtPlanDetailByTs(@RequestParam(required = true) String ts) {
        List<TtplanB> ttplanBS = ttplanBService.queryNCTtPlanDetailByTs(ts);
        return CommonResponse.success("查询物料基本档案同步数据成功！", ttplanBS);
    }

}
