package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.ICorpUserService;
import com.ejianc.business.dataexchange.service.IUserService;
import com.ejianc.business.dataexchange.vo.CorpUser;
import com.ejianc.business.dataexchange.vo.User;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class UserApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUserService userService;

    @Autowired
    private ICorpUserService corpUserService;


    /**
     * NC用户同步查询
     * @return
     */
    @GetMapping(value = "/user/list")
    public CommonResponse<List<User>> queryUsersByTs(@RequestParam(required = true) String ts) {
        List<User> listres = userService.selectListFromOriginalData(ts);
        return CommonResponse.success("查询用户同步数据成功！",listres);
    }

    /**
     * NC用户同步查询(区间)
     * @return
     */
    @GetMapping(value = "/user/listByQj")
    public CommonResponse<List<User>> queryUsersByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime) {
        List<User> listres = userService.selectListFromOriginalDataByQj(beginTime, endTime);
        return CommonResponse.success("查询用户同步数据成功！",listres);
    }

    /**
     * NC用户组织权限查询
     * @return
     */
    @GetMapping(value = "/corpuser/listByQj")
    public CommonResponse<List<CorpUser>> queryCorpUserByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
                                                            @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow) {
        logger.info("beginRow is ------>" + beginRow);
        logger.info("endRow is ------>" + endRow);
        List<CorpUser> listres = corpUserService.queryNCCorpUsersByQj(beginTime, endTime, beginRow, endRow);
        return CommonResponse.success("查询用户组织权限的同步数据成功！",listres);
    }


    /**
     * NC用户组织权限查询(区间)
     * @return
     */
    @GetMapping(value = "/corpuser/list")
    public CommonResponse<List<CorpUser>> queryCorpUserByTs(@RequestParam(required = true) String ts) {
        List<CorpUser> listres = corpUserService.queryNCCorpUsersByTs(ts);
        return CommonResponse.success("查询用户组织权限的同步数据成功！",listres);
    }
}
