package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.service.IAmountlistService;
import com.ejianc.business.dataexchange.service.ICmContractService;
import com.ejianc.business.dataexchange.vo.Amountlist;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


/**
 *
 */
@RestController
@RequestMapping("amountlist")
public class AmountlistController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAmountlistService amountlistService;


    @RequestMapping(value = "queryAmountlistRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<Amountlist>> queryAmountlistRef(
//            @RequestParam(value = "pkContract", required=true) String pkContract,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("entrynumber");
        fuzzyFields.add("htywnr");


        String entrynumber = null;
        String htywnr = null;
        String pkContract = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

            if(null != conditionMap.get("entrynumber")) {
                entrynumber = conditionMap.get("entrynumber").toString();
                logger.info("entrynumber--"+entrynumber);
            }
            if(null != conditionMap.get("htywnr")) {
                htywnr = conditionMap.get("htywnr").toString();
                logger.info("htywnr--"+htywnr);
            }
            /* pkContract改为由condition入参，必输，yqls 2021/07/23*/
            if(null != conditionMap.get("pkContract")) {
                pkContract = conditionMap.get("pkContract").toString();
                logger.info("pkContract--"+pkContract);
            } else {
                throw new BusinessException("请先选择合同！");
            }
        } else {
            throw new BusinessException("请先选择合同！");
        }

        Page<Amountlist> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);

        List<Amountlist> listres = amountlistService.selectListAll(page,wrapper,pkContract);
        IPage<Amountlist> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
