package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.InvmanMapper;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 物料管理档案接口 服务实现类
 * </p>
 *
 * @author Brin
 * @since 2020-11-04 15:59:15
 */
@Service("invmanService")
public class InvmanService extends ServiceImpl<InvmanMapper, Invman> implements IInvmanService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<Invman> selectListAll(String ts, String pkCorp) {
        return baseMapper.queryNCInmansByTs(ts, pkCorp);
    }

    @Override
    public List<Invman> selectListAllByQj(String beginTime, String endTime, Integer beginRow, Integer endRow, String pkCorp) {
        return baseMapper.queryNCInmansByQj(beginTime, endTime, beginRow, endRow, pkCorp);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime,  String tenantId, String pkCorp) {
        logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank(pkCorp));
        if (StringUtils.isNotBlank(pkCorp)) {
            List<Invman> invmanList = baseMapper.queryInmansByQj(beginTime, endTime, pkCorp);
            if(CollectionUtils.isNotEmpty(invmanList)){
                String json = JSONObject.toJSONString(invmanList);
                logger.info("put redis is " + pkCorp + "invmanList is " + json);
                redisTemplate.opsForValue().set(pkCorp + "@@@&&&", json,6000, TimeUnit.SECONDS);
            }
        }else{
            CommonResponse<List<String>> orgResponse = orgApi.findMainOrgByTenantId(Long.valueOf(tenantId));
            logger.info("before put time is " + new Date());
            if(CollectionUtils.isNotEmpty(orgResponse.getData())) {
                for (String pk : orgResponse.getData()) {
                    if (StringUtils.isBlank(pk)) {
                        continue;
                    }
                    List<Invman> invmanList = baseMapper.queryInmansByQj(beginTime, endTime, pk);
                    if(CollectionUtils.isNotEmpty(invmanList)){
                        String json = JSONObject.toJSONString(invmanList);
                        logger.info("put redis is " + pk + "invmanList is " + json);
                        redisTemplate.opsForValue().set(pk + "@@@&&&", json,6000, TimeUnit.SECONDS);
                    }
                }
            }
            logger.info("end put time is " + new Date());
        }
       return CommonResponse.success("redis物料管理档案同步数据成功！");
    }


}

