package com.ejianc.business.datalake.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.hystrix.MysteelHystrix;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 从数据湖获取我的钢铁网数据接口
 *
 * @author sunq
 *
 */
@FeignClient(name= "cscec5b-datalake-web", url="${common.env.feign-client-url}", path="cscec5b-datalake-web", fallback = MysteelHystrix.class)
public interface IMysteelApi {

	/**
	 * 地区参照
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/mysteel/getRegionRef1")
		public CommonResponse<List<RegionRefVO>> getRegionRef1(
			@RequestParam(value = "page") Page<RegionRefVO> page,
			@RequestParam(value = "wrapper") QueryWrapper wrapper,
			@RequestParam(value = "materialName") String materialName,
			@RequestParam(value = "checkDate") String checkDate);

	/**
	 * 品牌参照
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/mysteel/getBrandRef1")
		public CommonResponse<List<BrandRefVO>> getBrandRef1(
			@RequestParam(value = "page") Page<RegionRefVO> page,
			@RequestParam(value = "wrapper") QueryWrapper wrapper,
			@RequestParam(value = "materialName") String materialName,
			@RequestParam(value = "region") String region,
			@RequestParam(value = "checkDate") String checkDate);

	/**
	 * 根据网站、地区、品牌，计算出推荐价格（即市场价格）
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/mysteel/getRecomPrice1")
		public CommonResponse<BigDecimal> getRecomPrice1(
			@RequestParam(value = "region") String region,
			@RequestParam(value = "brand") String brand,
			@RequestParam(value = "materialName") String materialName,
			@RequestParam(value = "checkDate") String checkDate);

	/**
	 * 根据网站、地区、品牌，联查出市场价格
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/mysteel/getMarketPrice1")
		public CommonResponse<List<MarketPriceVO>> getMarketPrice1(
			@RequestParam(value = "region") String region,
			@RequestParam(value = "brand") String brand,
			@RequestParam(value = "materialName") String materialName,
			@RequestParam(value = "checkDate") String checkDate);

}
