/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datalake.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.bean.MarketPriceEntity;
import com.ejianc.business.datalake.mapper.MysteelMapper;
import com.ejianc.business.datalake.service.IMysteelService;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mysteelService")
public class MysteelServiceImpl
extends BaseServiceImpl<MysteelMapper, MarketPriceEntity>
implements IMysteelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<RegionRefVO> getRegionRef1(Page<RegionRefVO> page, QueryWrapper wrapper, String materialName, String checkDate) {
        List<RegionRefVO> list = ((MysteelMapper)this.baseMapper).getRegionRef1(page, wrapper, materialName, checkDate);
        return list;
    }

    @Override
    public List<BrandRefVO> getBrandRef1(Page<BrandRefVO> page, QueryWrapper wrapper, String materialName, String region, String checkDate) {
        List<BrandRefVO> list = ((MysteelMapper)this.baseMapper).getBrandRef1(page, wrapper, materialName, region, checkDate);
        return list;
    }

    @Override
    public BigDecimal getRecomPrice1(String region, String brand, String materialName, String checkDate) {
        BigDecimal price = ((MysteelMapper)this.baseMapper).getRecomPrice1(region, brand, materialName, checkDate);
        return price;
    }

    @Override
    public List<MarketPriceVO> getMarketPrice1(String region, String brand, String materialName, String checkDate) {
        List<MarketPriceVO> priceList = ((MysteelMapper)this.baseMapper).getMarketPrice1(region, brand, materialName, checkDate);
        return priceList;
    }

    private String getBeforeDay(String dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return simpleDateFormat.format(calendar.getTime());
    }

    public int daysBetween(String smdate, String bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(smdate));
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        long time1 = cal.getTimeInMillis();
        try {
            cal.setTime(sdf.parse(bdate));
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }
}

