package com.ejianc.business.fbxt.comment.api;

import com.ejianc.business.fbxt.comment.hystrix.MatSyncRecordHystrix;
import com.ejianc.business.fbxt.comment.vo.MatSyncRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = "cscec5b-fbxt-web", url = "${common.env.feign-client-url}", path = "cscec5b-fbxt-web", fallback = MatSyncRecordHystrix.class)
public interface IMatSyncRecordApi {
    /**
     * 同步nc是否已结算
     * @param recordVOList
     * @return
     */
    @PostMapping(value = "/api/matsync/insertBatch")
    CommonResponse<String> insertBatch(@RequestBody List<MatSyncRecordVO> recordVOList);
}
