package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.grap.Enum.BillSourceEnum;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.util.ContextHolderUtils;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("grap")
public class GrapBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${common.env.base-host}")
	private String BASE_HOST;

	@Autowired
	private IGrapService grapService;

	@Autowired
	private ISumGrapService sumGrapService;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private IAttachmentApi iAttachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		GrapEntity entity = grapService.selectById(billId);
		if (StringUtils.isNotBlank(entity.getSourceId()) && StringUtils.isNotBlank(entity.getSource()) && BillSourceEnum.供方推送.getCode().equals(entity.getSource())) {
			entity.setConfirmer(String.valueOf(InvocationInfoProxy.getUserid()));
			entity.setConfirmerName(userApi.findUserByUserId(InvocationInfoProxy.getUserid()).getData().getUserName());
			entity.setFeedback("确认通过");
			entity.setConfirmerData(new Date());
			grapService.updateById(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public synchronized CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return grapService.pushToSumGrap(billId);
	}


	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//		//是否被其他单据引用
//		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(res.isSuccess()) {//单据未被下游单据引用
//			return CommonResponse.success();
//		}else{
//			return CommonResponse.error(res.getMsg());
//		}
		GrapEntity entity = grapService.selectById(billId);
		if(entity.getUseState() != null && entity.getUseState() == 1){
			return CommonResponse.error("单据已被引用，不允许撤回！");
		}
		if(entity.getHistoryFlag() != null && entity.getHistoryFlag() == 1){
			return CommonResponse.error("历史数据，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		GrapEntity entity = grapService.selectById(billId);
		GrapVO grapVO = BeanMapper.map(entity, GrapVO.class);

		// 从进度台账撤回
		if(sumGrapService.getById(grapVO.getSumGrapId()) != null){
			SumGrapVO sumGrapVO = this.withdrawFromSumGrapVO(grapVO);
		}
		entity.setSumGrapId(null);
		grapService.updateById(entity);
		logger.info("--> 单据：" + billId + "已取消汇总");
		return CommonResponse.success();
	}

	/**
	 * 从进度台账撤回
	 * @param grapVO
	 * @return
	 */
	private SumGrapVO withdrawFromSumGrapVO(GrapVO grapVO) {
		logger.info("--> 单据：" + grapVO.getId() + "取消汇总开始");
		SumGrapEntity sumGrapEntity = sumGrapService.selectById(grapVO.getSumGrapId());
		SumGrapVO sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
		List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();
		Collections.sort(sumDetailList, new Comparator<SumGrapDetailVO>() {
			@Override
			public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
				Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
				int i = vlaue.intValue();
				return i;
			}
		});
		// 明细及非末级Map
		Map<Long, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-id，value-非末级VO
		Map<Long, SumGrapDetailVO> sumDetailMap = new LinkedHashMap<>();// 子表Map，key-id，value-所有子表VO
		if(CollectionUtils.isNotEmpty(sumDetailList)){
			for(SumGrapDetailVO vo : sumDetailList){
				if(vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())){
					parentMap.put(vo.getId(), vo);
				}
				if(!sumDetailMap.containsKey(vo.getId())){
					if(grapVO.getId().equals(vo.getGrapId())){
						vo.setRowState("del");
//							vo.setDetailIndex(null);
					}
					sumDetailMap.put(vo.getId(), vo);
				}
			}
		}
		// 构造子集
		if(CollectionUtils.isNotEmpty(sumDetailList)){
			for(SumGrapDetailVO vo : sumDetailList){
				Long parentId = vo.getParentId();
				if(parentMap.containsKey(parentId) && !"del".equals(vo.getRowState())){
					SumGrapDetailVO parentVO = parentMap.get(parentId);
					List<SumGrapDetailVO> children = parentVO.getChildren() != null ? parentVO.getChildren() : new ArrayList<>();
					if(!children.contains(vo)){
						children.add(vo);
					}
					parentVO.setChildren(children);
					parentMap.put(parentId, parentVO);
				}
			}
		}
		int parentRow = parentMap.size();// 非末级剩余行数
		// 重新计算非末级
		if(parentRow != 0){
			for(SumGrapDetailVO parentVO : parentMap.values()){
				List<SumGrapDetailVO> children = parentVO.getChildren();
				if(CollectionUtils.isNotEmpty(children)){
					BigDecimal num = null;// 汇总数量
					BigDecimal mny = null;// 汇总金额
					BigDecimal approveNum = null;// 汇总审批数量
					BigDecimal approveMny = null;// 汇总审批金额
					BigDecimal oldNum = null;// 汇总原始数量
					String construction = null;// 施工部位
					int index = 0;
					for(SumGrapDetailVO vo : children){
						num = DecimalUtils.add(num, vo.getNum());
						mny = DecimalUtils.add(mny, vo.getMny());
						approveNum = DecimalUtils.add(approveNum, vo.getApproveNum());
						approveMny = DecimalUtils.add(approveMny, vo.getApproveMny());
						oldNum = DecimalUtils.add(oldNum, vo.getOldNum());
						construction = this.getSumStr(construction, vo.getConstruction());
						index += 1;
						sumDetailMap.get(vo.getId()).setDetailIndex(parentVO.getDetailIndex() + "." + index);// 序号
					}
					parentVO.setNum(num);
					parentVO.setMny(mny);
					parentVO.setApproveNum(approveNum);
					parentVO.setApproveMny(approveMny);
					parentVO.setOldNum(oldNum);
					parentVO.setConstruction(construction);
					sumDetailMap.put(parentVO.getId(), parentVO);
				} else {
					parentVO.setRowState("del");
//						parentVO.setDetailIndex(null);
					sumDetailMap.put(parentVO.getId(), parentVO);
					parentRow -= 1;
				}
			}
		}
		sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
		// 重新计算表头
		if(sumDetailMap.size() > 0){
			BigDecimal sumMny = null;// 汇总金额
			BigDecimal sumApproveMny = null;// 汇总审核金额
			String description = null;// 进度说明
			for(SumGrapDetailVO vo : sumDetailMap.values()){
				if(vo.getLeafFlag() == 1 && !"del".equals(vo.getRowState())){
					sumMny = DecimalUtils.add(sumMny, vo.getMny());
					sumApproveMny = DecimalUtils.add(sumApproveMny, vo.getApproveMny());
					description = this.getSumStr(description, vo.getDescription());
				}
			}
			sumGrapVO.setSumMny(sumMny);
			sumGrapVO.setSumApproveMny(sumApproveMny);
			sumGrapVO.setDescription(description);
		}
		// 非末级行不为空则修改，否则删除
		if(parentRow > 0){
			logger.info("--> 汇总后进度台账VO：" + JSONObject.toJSONString(sumGrapVO));
			sumGrapService.saveOrUpdate(sumGrapVO);
		} else {
			logger.info("--> 进度台账VO：" + sumGrapVO.getId() + "已删除");
			sumGrapService.removeById(sumGrapVO.getId(), true);
		}
		// 删除已汇总的附件
		List<AttachmentVO> grapFileList = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "imgUpload1");
		List<AttachmentVO> sumGrapFileList = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "imgUpload1");
        List<AttachmentVO> grapFileList2 = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "bill");
        List<AttachmentVO> sumGrapFileList2 = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "bill");
        grapFileList.addAll(grapFileList2);
        sumGrapFileList.addAll(sumGrapFileList2);
		if(CollectionUtils.isNotEmpty(grapFileList) && CollectionUtils.isNotEmpty(sumGrapFileList)){
			Map<String, AttachmentVO> grapFileMap = grapFileList.stream().collect(Collectors.toMap(AttachmentVO::getFilePath, Function.identity()));
			List<String> ids = new ArrayList<>();
			for(AttachmentVO vo : sumGrapFileList){
				if(grapFileMap.containsKey(vo.getFilePath())){
					ids.add(String.valueOf(vo.getId()));
				}
			}
			if(CollectionUtils.isNotEmpty(ids)){
				iAttachmentApi.delete(String.join(",", ids));
			}
		}
		return sumGrapVO;
	}

	/**
	 * 汇总字符串，去重并去空格
	 * @param sumStr
	 * @param str
	 * @return
	 */
	private String getSumStr(String sumStr, String str) {
		if(org.apache.commons.lang.StringUtils.isNotEmpty(str)){
			str = str.replaceAll(" ", "");
		} else {
			return sumStr;
		}
		if(org.apache.commons.lang.StringUtils.isNotEmpty(sumStr)){
			String[] strs = sumStr.split(",");
			Set<String> strSet = new HashSet<>(Arrays.asList(strs));
			if(!strSet.contains(str)){
				sumStr = sumStr + "," + str;
			}
			return sumStr;
		} else {
			return str;
		}
	}

	/**
	 * 查询附件信息
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @return
	 */
	private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType){
		String url = BASE_HOST + "ejc-file-web/attachment/queryListBySourceId";
		Map<String, String> params = new HashMap();
		params.put("sourceId", String.valueOf(sourceId));
		params.put("billType", billType);
		params.put("sourceType", sourceType);
		try {
			String json = HttpTookit.get(url, params, ContextHolderUtils.getRequest());
			logger.info("请求：" + url +"?params={} 响应结果：{}", params, json);
			CommonResponse<JSONObject> response = JSONObject.parseObject(json, CommonResponse.class);
			String data = response.getData().getString("data");
			List<AttachmentVO> list = (List<AttachmentVO>) JSONArray.parseArray(data, AttachmentVO.class);
			return list;
		} catch (Exception e) {
			logger.error("获取文件信息异常，", e);
			return new ArrayList<>();
		}
	}

}
