package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.Enum.BillSourceEnum;
import com.ejianc.business.fbxt.grap.Enum.ConfirmStatusEnum;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.*;
import com.ejianc.business.fbxt.odd.bean.ReceiveEntity;
import com.ejianc.business.fbxt.odd.service.IReceiveService;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 进度计量实体
 *
 * @author generator
 *
 */
@Service("grapService")
public class GrapServiceImpl extends BaseServiceImpl<GrapMapper, GrapEntity> implements IGrapService{

    private static final String FBXT_GRAP = "FBXT_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi iProjectApi;

    @Autowired
    private ISupplierApi iSupplierApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private MsgUtil msgUtil;

    @Autowired
    private IReceiveService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjAssUpApplyUrl}")
    private String wjAssUpApplyUrl;

    @Value("${img.serverPath}")
    private String serverPath;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private ISumGrapService sumGrapService;



    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        if(null == saveorUpdateVO.getId()){
            saveorUpdateVO.setSource(BillSourceEnum.自制.getCode());
        }
        GrapEntity entity = BeanMapper.map(saveorUpdateVO, GrapEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getCropId() != null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgVO = orgApi.getOneById(entity.getCropId());
            if(!orgVO.isSuccess()) {
                throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
            }
            entity.setCropSourceId(orgVO.getData().getSourceId());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, GrapVO.class);
    }
    @Override
    public Long assSaveOrUpdate(AssignmrnyBookVO assignmrnyBookVO) {
        ProjectRegisterVO projectRegisterVO =new ProjectRegisterVO();
        if(assignmrnyBookVO.getPkProject()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse =  iProjectApi.queryProjectBySourceId(assignmrnyBookVO.getPkProject());
            if(ponse.getData()==null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            projectRegisterVO=ponse.getData();
        }
        GrapVO grapVO=new GrapVO();
        //主表
        Long projectId =  projectRegisterVO.getId();
        grapVO.setCropId(projectRegisterVO.getOrgId());//项目所属组织id
        grapVO.setCropName(projectRegisterVO.getOrgName());
        grapVO.setCropSourceId(assignmrnyBookVO.getPkOrg());//项目所属组织来源id
        grapVO.setOrgId(projectRegisterVO.getProjectDepartmentId());//组织
        OrgVO orgVO =new OrgVO();
        if(projectRegisterVO.getProjectDepartmentId()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(projectRegisterVO.getProjectDepartmentId());
            if(!orgVOCommonResponse.isSuccess()) {
                throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
            }
            orgVO = orgVOCommonResponse.getData();
        }
        grapVO.setOrgName(orgVO.getName());//组织名称
        grapVO.setOrgSourceId(orgVO.getSourceId());//组织来源id
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());//单据编号
        if(assignmrnyBookVO.getPkProject()!=null){
            grapVO.setProjectSourceId(assignmrnyBookVO.getPkProject());//项目来源Id
        }
        grapVO.setProjectId(projectId); //项目主键
        grapVO.setProjectName(assignmrnyBookVO.getProjectName());//项目名称
        grapVO.setContractId(assignmrnyBookVO.getPkContract()); //合同主键
        grapVO.setContractName(assignmrnyBookVO.getContractName()); // 合同名称
        grapVO.setContractCode(assignmrnyBookVO.getContractCode());//合同编码
         //合同编码contract_code
        grapVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());//单据状态
        grapVO.setDescription(assignmrnyBookVO.getMemo());// 进度说明 description
        grapVO.setSource(BillSourceEnum.供方推送.getCode());
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());//单据编号
        grapVO.setCreateUserName(assignmrnyBookVO.getCreatorName());
        if(assignmrnyBookVO.getPkSupplier()!=null){
              //查询项目部上级组织的的来源id
              CommonResponse<SupplierVO> supplier = iSupplierApi.queryBySourceId(assignmrnyBookVO.getPkSupplier());
              if(supplier.isSuccess()){
                  SupplierVO  supplierVO = supplier.getData();
                  grapVO.setSupplierId(supplierVO.getId());
                  grapVO.setSupplierName(supplierVO.getName());//供应商名称
              }
        }
        grapVO.setUseState(0);//是否已汇总默认为 未汇总
        grapVO.setSourceId(assignmrnyBookVO.getPkAssignmentBook());
        grapVO.setSupplierSourceId(assignmrnyBookVO.getPkSupplier());// 来源Id/主表Id
        grapVO.setConstruction(assignmrnyBookVO.getConstruction());//主表施工部位
        grapVO.setPkCreator(assignmrnyBookVO.getPkCreator());//编制人
        grapVO.setCreateDate(new Date());//编制日期create_date
        grapVO.setSumMny(assignmrnyBookVO.getSumMany());//总计金额
        grapVO.setSaveState(1);//推送到五局默认保存态
        //子表
        List<GrapDetailVO> detailList = new ArrayList<>();
        for (AssignmentInfoVO assignmentInfoVO : assignmrnyBookVO.getAssInfoList()) {
            GrapDetailVO grapDetil = new GrapDetailVO();
            grapDetil.setInfoId(assignmentInfoVO.getInfoId());
            grapDetil.setInfoCode(assignmentInfoVO.getInfoCode());// 清单编码
            grapDetil.setInfoName(assignmentInfoVO.getInfoName());// 清单名称 infoName
            grapDetil.setUnit(assignmentInfoVO.getInfoUnit());// 单位
            ////  五局数量 存放 供方完成量  五局供方完成量 就存供方完成量
            grapDetil.setNum(assignmentInfoVO.getInfoNumber());// 数量
            grapDetil.setPcaAmout(assignmentInfoVO.getInfoNumber());
            grapDetil.setPrice(assignmentInfoVO.getPrice());// // 无税单价 price
            grapDetil.setMny(assignmentInfoVO.getMny());// // mny; // 金额
            grapDetil.setSite(assignmentInfoVO.getInfoSite());//施工部位
            grapDetil.setSourceId(assignmentInfoVO.getPkBookInfo());//供方清单主键
            //累计完成量
            detailList.add(grapDetil);
        }
        grapVO.setDetailList(detailList);
        GrapEntity entity = BeanMapper.map(grapVO, GrapEntity.class);
        super.saveOrUpdate(entity, false);

        List<FileVO> fileVOList =assignmrnyBookVO.getFileList();
        if(CollectionUtils.isNotEmpty(fileVOList) && fileVOList.size() != 0){
            saveFile(fileVOList,entity.getId());
        }
        //查询需要发送消息的人员
        LambdaQueryWrapper<ReceiveEntity> query = new LambdaQueryWrapper<>();
        // 校验查询全部
        query.eq(ReceiveEntity::getDr, 0);
        List<ReceiveEntity> receiveEntityList = service.list(query);
        for(ReceiveEntity receiveEntity:receiveEntityList){
            Long userId = receiveEntity.getUserId();
            assBookMsg(entity,userId);
        }
        return entity.getId();
    }

    public void  assBookMsg(GrapEntity entity,Long userId){
        System.out.println(userId+"---------------------------------------------------------------------------");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("wjyGrap");
        String subject = "供应商【"+entity.getSupplierName()+"】提交的【施工任务书_"+entity.getBillCode()+"_" + sdf.format(new Date()) + "】需要确认或驳回";
        List<String> sender = new ArrayList<>();
        //String createUserId = msgUtil.getCreateUserId(userCode);
        sender.add(String.valueOf(userId));
        String formurl = baseHost + "cscec5b-fbxt-frontend/#/grap/card?id=" + entity.getId();
        String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        msgUtil.sendMsg(messageType, sender, "task", subject, content,entity.getId());
    }
    //保存推送照片信息
    public boolean saveFile(List<FileVO> fileVOList,Long id){
        //图片信息
        List<AttachmentVO> attachmentList = new ArrayList<>();
        for (FileVO fileVO : fileVOList) {
            AttachmentVO attachmentVO=new AttachmentVO();
            attachmentVO.setBillType("BT201202000000001");
            attachmentVO.setFileName(fileVO.getFileName());//文件名称
            attachmentVO.setFilePath(fileVO.getFilePath());//文件路径
            attachmentVO.setImgServerPath(serverPath);//服务地址路径
            attachmentVO.setOnlinePath(serverPath+fileVO.getFilePath());
            //所属模块主键
            attachmentVO.setSourceId(id);//所属模块主键
            attachmentVO.setSourceType("imgUpload1");
            attachmentVO.setTruePath(serverPath+fileVO.getFilePath());
            attachmentVO.setUploadUserName(" 供方平台");
            attachmentList.add(attachmentVO);
        }
        CommonResponse<String> flag = iAttachmentApi.insertBatch(attachmentList);
        if(!flag.getMsg().equals("新增成功") ){
            throw new BusinessException(flag.getMsg());
        }
        return true;
    }
    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<Boolean> supplierConfirm(SupplierConfirmVO billStateVO) {
        billStateVO.setPkAssignmentBook(selectById(billStateVO.getId()).getSourceId());
        if (ConfirmStatusEnum.驳回供方.getCode().equals(billStateVO.getBillState())) {
            super.removeById(billStateVO.getId());
        }
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            logger.info("--> 推送供方参数-----VO：" + JSONObject.toJSONString(billStateVO));
            CommonResponse<String> pushres = pushGrap(headers, billStateVO);
            logger.info("获取推送供方结果--" + JSONObject.toJSONString(pushres));
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }

        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
        return CommonResponse.success("成功！", true);
    }

    @Override
    public CommonResponse<String> pushToSumGrap(Long billId) {
        GrapEntity entity = selectById(billId);
        GrapVO grapVO = BeanMapper.map(entity, GrapVO.class);
        // 推送进度台账
        if(grapVO.getSumGrapId() == null){
            SumGrapVO sumGrapVO = pushToSumGrap(grapVO);

            entity.setSumGrapId(sumGrapVO.getId());
            updateById(entity);
            logger.info("--> 单据：" + billId + "已汇总到：" + entity.getSumGrapId());
        }
        //推送供方修改单据状态为已确认
        if (org.apache.commons.lang.StringUtils.isNotBlank(grapVO.getSourceId()) && org.apache.commons.lang.StringUtils.isNotBlank(grapVO.getSource()) && BillSourceEnum.供方推送.getCode().equals(grapVO.getSource())) {
            SupplierConfirmVO billStateVO = new SupplierConfirmVO();
            billStateVO.setId(billId);
            billStateVO.setBillState(ConfirmStatusEnum.确认通过.getCode());
            String confirmer =  org.apache.commons.lang.StringUtils.isNotBlank(entity.getConfirmer()) ? entity.getConfirmer() : String.valueOf(InvocationInfoProxy.getUserid());
            billStateVO.setConfirmer(confirmer);
            String confirmerName = org.apache.commons.lang.StringUtils.isNotBlank(entity.getConfirmerName()) ? entity.getConfirmerName() : userApi.findUserByUserId(InvocationInfoProxy.getUserid()).getData().getUserName();
            billStateVO.setConfirmerName(confirmerName);
            billStateVO.setFeedback("确认通过");
            billStateVO.setPkAssignmentBook(grapVO.getSourceId());
            billStateVO.setFlag(1);//添加回写标识
            //获取子表数据
            List<AssignmentInfoVO> assignmentInfoVOList=new ArrayList<>();
            for (GrapDetailVO grapDetailVO : grapVO.getDetailList()) {
                if(grapDetailVO.getSourceId() != null){//来源id为空证明不是来自供方，不推送供方
                    AssignmentInfoVO assignmentInfoVO = new AssignmentInfoVO();
                    assignmentInfoVO.setPkBookInfo(grapDetailVO.getSourceId());// 清单主键
                    assignmentInfoVO.setInfoProjectNumber(grapDetailVO.getNum());// 五局数量对应供放项目部审核数量
                    assignmentInfoVOList.add(assignmentInfoVO);
                }
            }
            if(CollectionUtils.isNotEmpty(assignmentInfoVOList)){
                billStateVO.setAssInfoList(assignmentInfoVOList);
            }
            supplierConfirm(billStateVO);
        }
        return CommonResponse.success();
    }

    /**
     * 推送进度台账
     * @param grapVO
     * @return
     */
    private SumGrapVO pushToSumGrap(GrapVO grapVO) {
        logger.info("--> 单据：" + grapVO.getId() + "汇总开始");
        List<GrapDetailVO> detailList = grapVO.getDetailList();
        LambdaQueryWrapper<SumGrapEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SumGrapEntity::getContractId, grapVO.getContractId());
        // 查询自由态/审批驳回
        wrapper.and(x -> x.eq(SumGrapEntity::getBillState, 0).or().eq(SumGrapEntity::getBillState, 4));
//		wrapper.eq(SumGrapEntity::getBillState, 0);
        List<SumGrapEntity> sumGrapList = sumGrapService.list(wrapper);
        // 明细及非末级Map
        SumGrapVO sumGrapVO = null;
        Map<String, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-infoId，value-非末级VO
        Map<Long, SumGrapDetailVO> sumDetailMap = new HashMap<>();// 子表Map，key-id，value-所有子表VO
        boolean isSum = false;// 是否已汇总
        if (CollectionUtils.isEmpty(sumGrapList)) {
            // 新增进度台账
            sumGrapVO = this.getSumGrapVO(grapVO);// 构造主表VO
            // 子表
            if (CollectionUtils.isNotEmpty(detailList)) {
                for (GrapDetailVO detail : detailList) {
                    this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                }
                sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
            }
            sumGrapVO = sumGrapService.saveOrUpdate(sumGrapVO);
        } else {
            // 汇总进度台账
            SumGrapEntity sumGrapEntity = sumGrapService.selectById(sumGrapList.get(0).getId());
            sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
            if (CollectionUtils.isNotEmpty(detailList)) {
                // 已汇总进度计量明细主键
                List<Long> detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                for (GrapDetailVO detail : detailList) {
                    if (detailIds.contains(detail.getId())) {
                        isSum = true;
                    }
                }
            }
            if (!isSum) {
                sumGrapVO.setDescription(this.getSumStr(sumGrapVO.getDescription(), grapVO.getDescription()));// 汇总进度说明
                sumGrapVO.setSumMny(DecimalUtils.add(sumGrapVO.getSumMny(), grapVO.getSumMny()));// 汇总金额
                sumGrapVO.setSumApproveMny(DecimalUtils.add(sumGrapVO.getSumApproveMny(), grapVO.getSumMny()));// 汇总审批金额
                List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();
                for (SumGrapDetailVO detail : sumDetailList) {
                    if (detail.getLeafFlag() == 0 && !parentMap.containsKey(detail.getInfoId())) {
                        parentMap.put(detail.getInfoId(), detail);
                    }
                    if (!sumDetailMap.containsKey(detail.getId())) {
                        sumDetailMap.put(detail.getId(), detail);
                    }
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    // 已汇总进度计量明细主键
                    List<Long> detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                    for (GrapDetailVO detail : detailList) {
                        if (!detailIds.contains(detail.getId())) {
                            this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                        }
                    }
                    sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
                }
                sumGrapVO = sumGrapService.saveOrUpdate(sumGrapVO);
            }
        }
        logger.info("--> 汇总后进度台账VO：" + JSONObject.toJSONString(sumGrapVO));
        // 图片汇总
        if (!isSum) {
            CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(grapVO.getId()), "BT201202000000001", "imgUpload1",
                    String.valueOf(sumGrapVO.getId()), "BT201202000000002", "imgUpload1");
            CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(grapVO.getId()), "BT201202000000001", "bill",
                    String.valueOf(sumGrapVO.getId()), "BT201202000000002", "bill");
        }
        return sumGrapVO;
    }

    /**
     * 构造主表VO
     * @param grapVO
     * @return
     */
    private SumGrapVO getSumGrapVO(GrapVO grapVO) {
        SumGrapVO vo = new SumGrapVO();
        vo.setProjectId(grapVO.getProjectId());// 项目主键
        vo.setProjectName(grapVO.getProjectName());// 项目名称
        vo.setProjectSourceId(grapVO.getProjectSourceId());// 项目来源ID
        vo.setContractId(grapVO.getContractId());// 合同主键
        vo.setContractCode(grapVO.getContractCode());// 合同编码
        vo.setContractName(grapVO.getContractName());// 合同名称
        vo.setCropId(grapVO.getCropId());// 组织主键
        vo.setCropName(grapVO.getCropName());// 组织主键
        vo.setCropSourceId(grapVO.getCropSourceId());// 组织来源ID
        vo.setOrgId(grapVO.getOrgId());// 项目部主键
        vo.setOrgName(grapVO.getOrgName());// 项目部名称
        vo.setOrgSourceId(grapVO.getOrgSourceId());// 项目部来源ID
        vo.setSupplierId(grapVO.getSupplierId());// 供应商主键
        vo.setSupplierName(grapVO.getSupplierName());// 供应商名称
        vo.setSupplierSourceId(grapVO.getSupplierSourceId());// 供应商来源ID
        vo.setCreateUserId(InvocationInfoProxy.getUserid());// 制单人主键
        vo.setCreateUserName(sessionManager.getUserContext().getUserName());// 制单人名称
        vo.setUseState(0);// 是否NC已结算，0-未结算，1-已结算
        // 汇总
        vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(grapVO.getCreateDate()));
        vo.setSumMny(grapVO.getSumMny());// 汇总金额
        vo.setSumApproveMny(grapVO.getSumMny());// 汇总审核金额
        vo.setDescription(grapVO.getDescription());// 进度说明
        return vo;
    }

    /**
     * 构造子表VO
     * @param grapVO
     * @param detail
     * @param parentMap
     * @param sumDetailMap
     */
    private void dealSumDetailMap(GrapVO grapVO, GrapDetailVO detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
        String infoId = detail.getInfoId();
        // 新增末级
        SumGrapDetailVO vo = new SumGrapDetailVO();
        vo.setGrapId(grapVO.getId());// 计量单主键
        vo.setGrapDetailId(detail.getId());// 计量单子表主键
        vo.setInfoId(detail.getInfoId());// 合同清单主键
//		vo.setInfoCode(detail.getInfoCode());// 合同清单编码
//		vo.setInfoName(detail.getInfoName());// 合同清单名称
//		vo.setUnit(detail.getUnit());// 单位
//		vo.setPrice(detail.getPrice());// 单价
        vo.setNum(detail.getNum());// 数量
        vo.setApproveNum(detail.getNum());// 审批数量
        vo.setOldNum(detail.getNum());// 原始数量
        vo.setMny(detail.getMny());// 金额
        vo.setApproveMny(detail.getMny());// 审批金额
        vo.setConstruction(grapVO.getConstruction());// 施工部位
        vo.setDescription(grapVO.getDescription());// 进度说明
        vo.setCommitUserId(grapVO.getCreateUserId());// 提交人主键
        vo.setCommitUserName(grapVO.getCreateUserName());// 提交人名称
        // 处理非末级VO
        Long parentId = null;
        SumGrapDetailVO parentVO = null;
        if(!parentMap.containsKey(infoId)){
            // 新增
            parentId = IdWorker.getId();// 生成随机主键
            parentVO = new SumGrapDetailVO();
            parentVO.setId(parentId);// 主键
            parentVO.setInfoId(detail.getInfoId());// 合同清单主键
            parentVO.setInfoCode(detail.getInfoCode());// 合同清单编码
            parentVO.setInfoName(detail.getInfoName());// 合同清单名称
            parentVO.setUnit(detail.getUnit());// 单位
            parentVO.setPrice(detail.getPrice());// 单价
            parentVO.setNum(detail.getNum());// 数量
            parentVO.setApproveNum(detail.getNum());// 审批数量
            parentVO.setOldNum(detail.getNum());// 原始数量
            parentVO.setMny(detail.getMny());// 金额
            parentVO.setApproveMny(detail.getMny());// 审批金额
            parentVO.setConstruction(grapVO.getConstruction());// 施工部位
            parentVO.setLeafFlag(0);// 是否末级，0-否，1-是
            parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));// 序号
            parentMap.put(infoId, parentVO);
        } else {
            // 汇总
            parentVO = parentMap.get(infoId);
            parentId = parentVO.getId();
            parentVO.setNum(DecimalUtils.add(parentVO.getNum(), detail.getNum()));// 汇总数量
            parentVO.setApproveNum(DecimalUtils.add(parentVO.getApproveNum(), detail.getNum()));// 汇总审批数量
            parentVO.setOldNum(DecimalUtils.add(parentVO.getOldNum(), detail.getNum()));// 汇总原始数量
            parentVO.setMny(DecimalUtils.add(parentVO.getMny(), detail.getMny()));// 汇总金额
            parentVO.setApproveMny(DecimalUtils.add(parentVO.getApproveMny(), detail.getMny()));// 汇总审批金额
            String construction = this.getSumStr(parentVO.getConstruction(), grapVO.getConstruction());
            parentVO.setConstruction(construction);// 汇总施工部位
        }
        sumDetailMap.put(parentId, parentVO);// 放入非末级VO
        vo.setLeafFlag(1);// 是否末级，0-否，1-是
        vo.setParentId(parentId);// 父级主键
        vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));// 序号
        sumDetailMap.put(detail.getId(), vo);// 放入末级VO
    }

    /**
     * 汇总字符串，去重并去空格
     * @param sumStr
     * @param str
     * @return
     */
    private String getSumStr(String sumStr, String str) {
        if(org.apache.commons.lang.StringUtils.isNotEmpty(str)){
            str = str.replaceAll(" ", "");
        } else {
            return sumStr;
        }
        if(org.apache.commons.lang.StringUtils.isNotEmpty(sumStr)){
            String[] strs = sumStr.split(",");
            Set<String> strSet = new HashSet<>(Arrays.asList(strs));
            if(!strSet.contains(str)){
                sumStr = sumStr + "," + str;
            }
            return sumStr;
        } else {
            return str;
        }
    }

    /**
     * 获取子表末级排序
     * @param map
     * @param parentId
     * @return
     */
    private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
        int index = 1;
        for(SumGrapDetailVO vo : map.values()){
            if(parentId.equals(vo.getParentId())){
                index += 1;
            }
        }
        return index;
    }

    public CommonResponse<String> pushGrap(Map<String, String> headers, SupplierConfirmVO copy) {
        String url = wjAssUpApplyUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }
}
