package com.ejianc.business.fbxt.odd.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 零星用工申请单实体
 *
 * @author generator
 *
 */
 @TableName("ejc_fbxt_odd_info")
public class OddInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="odd_id")
    private Long oddId; // 零星用工主键
    @TableField(value="info_apply_id")
    private Long infoApplyId; // 申请子表主键，申请制单才有
    @TableField(value="name")
    private String name; // 清单名称
    @TableField(value="num")
    private java.math.BigDecimal num; // 数量
    @TableField(value="apply_num")
    private java.math.BigDecimal applyNum; // 申请数量，申请制单才有
    @TableField(value="price")
    private java.math.BigDecimal price; // 无税单价
    @TableField(value="mny")
    private java.math.BigDecimal mny; // 金额
    @TableField(value="code")
    private String code; // 清单编码
    @TableField(value="info_unit")
    private String infoUnit; // 单位
    @TableField(value="review_num")
    private java.math.BigDecimal reviewNum; // 审核数量
    @TableField(value="review_price")
    private java.math.BigDecimal reviewPrice; // 审核单价
    @TableField(value="review_mny")
    private java.math.BigDecimal reviewMny; // 审核金额
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型，0--引用，1-手工新增
    @TableField(value = "first_apply")
    private Integer firstApply; // 是否甲方申请，0-未申请，1-甲方申请
    @TableField(value="source_id")
    private String sourceId; // 来源主键
    @TableField(value="begin_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date beginTime; // 开始时间
    @TableField(value="end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endTime; // 结束时间
    @TableField(value="zkcontract")
    private String zkcontract; // 转扣合同
    @TableField(value="zkcorpname")
    private String zkcorpname; // 转扣单位
    @TableField(value="sum_redirect_mny")
    private java.math.BigDecimal sumRedirectMny; // 累计转扣金额
    @TableField(value="file_type")
    private String fileType; // 附件唯一标识
    @TableField(value = "info_nc_flag")
    private Integer infoNcFlag; // nc是否结算，0-否，1-是
    @TableField(value="pk_measdoc")
    private String pkMeasdoc; // 单位主键

    @TableField(exist = false)
    @SubEntity(serviceName = "oddRedirectService",pidName = "infoId")
    private List<OddRedirectEntity> oddRedirectEntities = new ArrayList<>(); // 零星用工转扣实体

    @TableField(value="pk_amountlist")
    private String pkAmountlist; // 分录主键

    @TableField(value="htywnr")
    private String htywnr; // 分录名称

    public String getHtywnr() {
        return htywnr;
    }

    public void setHtywnr(String htywnr) {
        this.htywnr = htywnr;
    }

    public String getPkAmountlist() {
        return pkAmountlist;
    }

    public void setPkAmountlist(String pkAmountlist) {
        this.pkAmountlist = pkAmountlist;
    }

    public Integer getInfoNcFlag() {
        return infoNcFlag;
    }

    public void setInfoNcFlag(Integer infoNcFlag) {
        this.infoNcFlag = infoNcFlag;
    }

    /**
     * 零星用工主键
     */
    public Long getOddId() {
        return oddId;
    }

    /**
     * 零星用工主键
     */
    public void setOddId(Long oddId) {
        this.oddId = oddId;
    }
    /**
     * 申请子表主键，申请制单才有
     */
    public Long getInfoApplyId() {
        return infoApplyId;
    }

    /**
     * 申请子表主键，申请制单才有
     */
    public void setInfoApplyId(Long infoApplyId) {
        this.infoApplyId = infoApplyId;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 申请数量，申请制单才有
     */
    public java.math.BigDecimal getApplyNum() {
        return applyNum;
    }

    /**
     * 申请数量，申请制单才有
     */
    public void setApplyNum(java.math.BigDecimal applyNum) {
        this.applyNum = applyNum;
    }
    /**
     * 无税单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 无税单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 金额
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 清单编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单位
     */
    public String getInfoUnit() {
        return infoUnit;
    }

    /**
     * 单位
     */
    public void setInfoUnit(String infoUnit) {
        this.infoUnit = infoUnit;
    }
    /**
     * 审核数量
     */
    public java.math.BigDecimal getReviewNum() {
        return reviewNum;
    }

    /**
     * 审核数量
     */
    public void setReviewNum(java.math.BigDecimal reviewNum) {
        this.reviewNum = reviewNum;
    }
    /**
     * 审核单价
     */
    public java.math.BigDecimal getReviewPrice() {
        return reviewPrice;
    }

    /**
     * 审核单价
     */
    public void setReviewPrice(java.math.BigDecimal reviewPrice) {
        this.reviewPrice = reviewPrice;
    }
    /**
     * 审核金额
     */
    public java.math.BigDecimal getReviewMny() {
        return reviewMny;
    }

    /**
     * 审核金额
     */
    public void setReviewMny(java.math.BigDecimal reviewMny) {
        this.reviewMny = reviewMny;
    }
    /**
     * 来源类型，0--引用，1-手工新增
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型，0--引用，1-手工新增
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 是否甲方申请，0-未申请，1-甲方申请
     */
    public Integer getFirstApply() {
        return firstApply;
    }

    public void setFirstApply(Integer firstApply) {
        this.firstApply = firstApply;
    }

    /**
     * 来源主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 开始时间
     */
    public Date getBeginTime() {
        return beginTime;
    }

    /**
     * 开始时间
     */
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }
    /**
     * 结束时间
     */
    public Date getEndTime() {
        return endTime;
    }

    /**
     * 结束时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getZkcontract() {
        return zkcontract;
    }

    public void setZkcontract(String zkcontract) {
        this.zkcontract = zkcontract;
    }

    public String getZkcorpname() {
        return zkcorpname;
    }

    public void setZkcorpname(String zkcorpname) {
        this.zkcorpname = zkcorpname;
    }

    /**
     * 累计转扣金额
     */
    public java.math.BigDecimal getSumRedirectMny() {
        return sumRedirectMny;
    }

    /**
     * 累计转扣金额
     */
    public void setSumRedirectMny(java.math.BigDecimal sumRedirectMny) {
        this.sumRedirectMny = sumRedirectMny;
    }
    /**
     * 附件唯一标识
     */
    public String getFileType() {
        return fileType;
    }

    /**
     * 附件唯一标识
     */
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public List<OddRedirectEntity> getOddRedirectEntities() {
        return oddRedirectEntities;
    }

    public void setOddRedirectEntities(List<OddRedirectEntity> oddRedirectEntities) {
        this.oddRedirectEntities = oddRedirectEntities;
    }

    public String getPkMeasdoc() {
        return pkMeasdoc;
    }

    public void setPkMeasdoc(String pkMeasdoc) {
        this.pkMeasdoc = pkMeasdoc;
    }
}
