package com.ejianc.business.fbxt.odd.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

@RestController
@RequestMapping("/api/odd")
public class OddSyncApi implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOddService service;
    @Autowired
    private IOddSyncApi oddSyncApi;

    /**
     * 同步nc是否已结算
     * @param
     * @return
     */
//    @PostMapping(value = "settleNc")
//    public CommonResponse<String> settleNc(@RequestBody OddSyncVo vo) {
//        return service.settleNc(vo);
//    }
    @PostMapping(value = "/settleNc")
    public CommonResponse<String> settleNc(HttpServletRequest request) {
        logger.info("--> 同步NC中间表开始");
        String param = request.getParameter("param");
        JSONArray jsonArray = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是：" + param + "----");
        int day = jsonArray.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是：" + day + "----");
        CommonResponse<OddSyncVo> oddSyncVoResponse = oddSyncApi.updateStatus(day);
        logger.info("零星用工同步NC回参：" + JSONObject.toJSONString(oddSyncVoResponse));
        if(oddSyncVoResponse.isSuccess()){
            return service.settleNc(oddSyncVoResponse.getData());
        }else {
            return CommonResponse.error(oddSyncVoResponse.getMsg());
        }

    }

}
