package com.ejianc.business.fbxt.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.news.bean.NewsEntity;
import com.ejianc.business.fbxt.news.bean.NewsSupplierEntity;
import com.ejianc.business.fbxt.news.mapper.NewsMapper;
import com.ejianc.business.fbxt.news.service.INewsService;
import com.ejianc.business.fbxt.news.vo.News;
import com.ejianc.business.fbxt.news.vo.NewsSupplierVO;
import com.ejianc.business.fbxt.news.vo.NewsVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 新闻实体
 *
 * @author generator
 */
@Service("newsService")
public class NewsServiceImpl extends BaseServiceImpl<NewsMapper, NewsEntity> implements INewsService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String BILL_CODE = "FBXT_NEWS";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value("${openApi.newsInsertUrl}")
    private String newsInsertUrl;
    @Value("${openApi.newsDelUrl}")
    private String newsDelUrl;
    @Value("${openApi.newsPageUrl}")
    private String newsPageUrl;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public NewsVO queryDetail(Long id) {
        NewsEntity entity = selectById(id);
        NewsVO vo = BeanMapper.map(entity, NewsVO.class);
        return vo;
    }

    @Override
    public JSONObject queryRecordList(QueryParam param) {
        String pkNews = String.valueOf(param.getParams().get("pkNews").getValue());
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            JSONObject query = new JSONObject();
            query.put("pkNews", pkNews);
            query.put("page", param.getPageIndex());
            query.put("rows", param.getPageSize());
            query.put("text", param.getSearchText());
            try {
                logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                JSONObject jsonBack = JSONObject.parseObject(HttpTookit.postByJson(newsPageUrl, query.toString(), headers));
                logger.info("---回参:" + jsonBack);
                if ("200".equals(jsonBack.getString("code"))) {
                    return jsonBack;
                } else {
                    throw new BusinessException("查询供方记录失败");
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                throw new BusinessException("查询供方记录失败");
            }
        }
        return null;
    }

    @Override
    public CommonResponse<String> pushToSupplier(Long id) {
        NewsEntity newsEntity = selectById(id);
        newsEntity.setPublishTime(new Date());
        saveOrUpdate(newsEntity);
        News news = BeanMapper.map(newsEntity, News.class);
        news.setPkNews(String.valueOf(id));
        if(CollectionUtils.isNotEmpty(newsEntity.getDetailList())){
            List<String> supplierList = newsEntity.getDetailList().stream().map(NewsSupplierEntity::getSourceSupplierId).collect(Collectors.toList());
            news.setPkSupplier(StringUtils.join(supplierList, "@"));
        }
        //获取附件  传送供方
        List<FileRelation> orderfileList = new ArrayList<>();
        CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(id, "BT231019000000001", "news", null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
            List<AttachmentVO> fileList = fileResponse.getData();
            for (AttachmentVO fileVo : fileList) {
                FileRelation file = new FileRelation();
                file.setFileName(fileVo.getFileName());
                file.setFilePath(fileVo.getFilePath());
                file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                file.setFileBizPk(String.valueOf(id));
                file.setDr(0);
                file.setFileBiz("news");
                file.setBizType("0");// 附件业务标识
                orderfileList.add(file);
            }
        }
        news.setFileList(orderfileList);
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            try {
                logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                JSONObject jsonBack = JSONObject.parseObject(HttpTookit.postByJson(newsInsertUrl, JSONObject.toJSON(news).toString(), headers));
                logger.info("---回参:" + jsonBack);
                if (!"200".equals(jsonBack.getString("code"))) {
                    return  CommonResponse.error("推送供方失败！");
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return  CommonResponse.error("推送供方失败！");
            }
        }
        return  CommonResponse.success("推送供方成功！");
    }

    @Override
    public CommonResponse<String> deleteSupplier(Long id) {
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            try {
                logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                Map<String, String> map = new HashMap<>();
                map.put("id", String.valueOf(id));
                JSONObject jsonBack = JSONObject.parseObject(HttpTookit.get(newsDelUrl, map, headers));
                logger.info("---回参:" + jsonBack);
                if (!"200".equals(jsonBack.getString("code"))) {
                    return  CommonResponse.error("删除供方失败！");
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return  CommonResponse.error("删除供方失败！");
            }
        }
        return  CommonResponse.success("删除供方成功！");
    }

    @Override
    public NewsVO saveOrUpdate(NewsVO saveOrUpdateVO) {
        UserContext userContextCache =sessionManager.getUserContext();
        NewsEntity entity = BeanMapper.map(saveOrUpdateVO, NewsEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setPublishUser(userContextCache.getUserName());
        }
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())){
            List<String> supplierList = saveOrUpdateVO.getDetailList().stream().map(NewsSupplierVO::getSupplierName).collect(Collectors.toList());
            entity.setSupplierName(StringUtils.join(supplierList, ","));
        }
        saveOrUpdate(entity, false);
        NewsVO vo = BeanMapper.map(entity, NewsVO.class);
        return vo;
    }


    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }
}
