package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.*;
import com.ejianc.business.fbxt.odd.cons.BillCons;
import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.service.*;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.*;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.gson.Gson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 零星用工实体
 *
 * @author generator
 */
@Service("oddService")
public class OddServiceImpl extends BaseServiceImpl<OddMapper, OddEntity> implements IOddService {
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IOddSyncApi oddSyncApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ISupplierApi supplierApi;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjOddJobUrl}")
    private String wjOddJobUrl;

    @Value("${openApi.wjOddPcaUrl}")
    private String wjOddPcaUrl;

    @Value("${openApi.wjOddPcaDelUrl}")
    private String wjOddPcaDelUrl;

    @Value("${openApi.wjOddApplyUsedUrl}")
    private String wjOddApplyUsedUrl;

    @Value("${openApi.wjOddApplyBatchNoUsedUrl}")
    private String wjOddApplyBatchNoUsedUrl;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private MsgUtil msgUtil;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        logger.error("odd save json is " + JSONObject.toJSONString(saveorUpdateVO));
        CommonResponse<String> response = oddSyncApi.nameContain(BeanMapper.map(saveorUpdateVO, com.ejianc.business.sync.vo.OddVO.class));
        logger.error(JSONObject.toJSONString(response));
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
//        if(saveorUpdateVO.getOddInfoEntities() != null){
//            //获取去重的分录主键
//            HashSet<String> pkAmountlists = new HashSet<>();
//            for(OddInfoVO oddInfoVO : saveorUpdateVO.getOddInfoEntities()){
//                String pkAmountlist = oddInfoVO.getPkAmountlist() ;//分录主键
//                if(StringUtils.isNotEmpty(oddInfoVO.getPkAmountlist())){
//                    pkAmountlists.add(pkAmountlist);
//                }
//            }
//            if(pkAmountlists.size() != 0){
//                for(String pkAmountlist : pkAmountlists){
//                    CommonResponse<String> commonResponse = oddSyncApi.codeContain(saveorUpdateVO.getContractId(),pkAmountlist);
//                    logger.error(new Gson().toJson(commonResponse));
//                    if(!commonResponse.isSuccess()){
//                        throw new BusinessException(commonResponse.getMsg());
//                    }
//                }
//            }
//        }
        if(saveorUpdateVO.getOddStatus() != null && saveorUpdateVO.getOddStatus() == 0 ){
            dealInfo(saveorUpdateVO.getOddInfoEntities());
        }else{
            isEnter(saveorUpdateVO.getOddInfoEntities());
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            //查询是否有相同的分录主键、清单编码、合同主键
            String contractId = saveorUpdateVO.getContractId();
            List<String> codeAndpkAmountlists = new ArrayList<>();
            if(saveorUpdateVO.getOddInfoEntities() != null){
                for(OddInfoVO oddInfoVO : saveorUpdateVO.getOddInfoEntities()){
                    String pkAmountlist =StringUtils.isEmpty(oddInfoVO.getPkAmountlist()) ? "" : oddInfoVO.getPkAmountlist() ;//分录主键
                    String code = StringUtils.isEmpty(oddInfoVO.getCode()) ? "" : oddInfoVO.getCode();//清单编码
                    String codeAndpkAmountlist =pkAmountlist + code;
                    codeAndpkAmountlists.add(codeAndpkAmountlist);
                }
            }
            List<String> codes =  baseMapper.check(codeAndpkAmountlists,contractId);
            if(CollectionUtils.isNotEmpty(codes)){
                String message = "";
                for(String code : codes){
                    message = message+code+",";
                }
                throw new BusinessException("清单编码被别的单据使用，无法保存["+message+"]");
            }
            saveorUpdateVO.setOddSource(0);
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "add";
        }


        CommonResponse<OrgVO> cropVo = orgApi.getOneById(entity.getCropId());
        if (!cropVo.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        if (null != cropVo.getData()) {
            entity.setCropSourceId(cropVo.getData().getSourceId());
        }
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(orgVo.getData().getSourceId());
        }
        // 查询项目部NC 实际所属组织的的来源id
        CommonResponse<ProjectRegisterVO> project = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
        if(project.isSuccess()){
            entity.setRealCorpId(project.getData().getRealCorpId());
            entity.setRealNcCorp(project.getData().getRealNcCorp());
            entity.setRealCorpName(project.getData().getRealCorpName());
        } else {
            throw new BusinessException("查询项目信息详情失败！");
        }
        List<OddInfoEntity> oddInfoEntities = BeanMapper.mapList(saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);  // 获取清单列表实体
        List<Long> fileIds = saveorUpdateVO.getFileIds();                 // 获取实体Odd的所有字段名称
        entity.setImportFlag(0);
        if(CollectionUtils.isNotEmpty(oddInfoEntities)){
            for(OddInfoEntity oddInfoEntity : oddInfoEntities){
                oddInfoEntity.setInfoNcFlag(0);
                StringBuffer zkcontract = new StringBuffer();//转扣合同
                StringBuffer zkcorpname = new StringBuffer();//转扣单位
                if(CollectionUtils.isNotEmpty(oddInfoEntity.getOddRedirectEntities())){
                    for(OddRedirectEntity oddRedirectEntity : oddInfoEntity.getOddRedirectEntities()){
                        if(oddRedirectEntity.getContractName() != null){
                            zkcontract.append(oddRedirectEntity.getContractName()+",");
                        }
                        if(oddRedirectEntity.getSuppliername() != null){
                            zkcorpname.append(oddRedirectEntity.getSuppliername()+",");
                        }
                    }

                    if(zkcontract.length()>0){
                        zkcontract.deleteCharAt(zkcontract.length()-1);
                    }
                    if(zkcorpname.length()>0){
                        zkcorpname.deleteCharAt(zkcorpname.length()-1);
                    }
                    oddInfoEntity.setZkcontract(zkcontract.toString());
                    oddInfoEntity.setZkcorpname(zkcorpname.toString());
                }else{
                    oddInfoEntity.setZkcontract(null);
                    oddInfoEntity.setZkcorpname(null);
                }
            }
        }
        entity.setOddInfoEntities(oddInfoEntities);

        LambdaQueryWrapper<OddEntity> lambda1 = Wrappers.<OddEntity>lambdaQuery();
        lambda1.eq(OddEntity::getProjectId, saveorUpdateVO.getProjectId())
                .eq(OddEntity::getContractId, saveorUpdateVO.getContractId())
                .isNotNull(OddEntity::getReviewMny)
                .eq(OddEntity::getSettleNcFlag, 1);
        List<OddEntity> oddEntityList = list(lambda1);
        oddEntityList.stream().map(OddEntity::getReviewMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        saveOrUpdate(entity, false);

        if (entity.getOddApplyId() != null) {
            syncApplyFile(entity.getOddApplyId(), entity.getId());
        }
        if ("edit".equals(operateType)) {
            //删除所有
            redirectService.remove(new QueryWrapper<OddRedirectEntity>().eq("odd_id", entity.getId()));
        }

        List<OddRedirectEntity> saveRedirects = new ArrayList<>();
        for (OddInfoEntity info : entity.getOddInfoEntities()) {
            List<OddRedirectEntity> list = info.getOddRedirectEntities();
            if (CollectionUtils.isNotEmpty(list)) {
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(entity.getId());
                    re.setId(null);
                    re.setRedirectNcFlag(0);
                    saveRedirects.add(re);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(saveRedirects)) {
            redirectService.saveBatch(saveRedirects);
        }

        //零星用工自由态即回写 ，暂存不回写  删除时释放
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {      // 零星用工申请单的update功能
            //判断申请单重复
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter(QueryParam.NE, 0));
            queryParam.getParams().put("oddApplyId", new Parameter(QueryParam.EQ, entity.getOddApplyId()));
            List<OddEntity> oddEntities = super.queryList(queryParam, false);
            if (oddEntities != null && oddEntities.size() > 0) {
                throw new BusinessException("该用工申请单已被引用");
            }
            //回写，如果申请单推送给供方，供方也要
            OddApplyEntity oddApplyEntity = oddApplyService.selectById(entity.getOddApplyId());
            if (oddApplyEntity.getPassFlag() != null && oddApplyEntity.getPassFlag() != -1) {
                // 同步供方
                String url = wjOddApplyUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOdd(entity.getId());
                request.setPkOddApply(entity.getOddApplyId());
                request.setIsused(1);
                writeBackApplyToSupl(request, url);
            }
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, 1);
            updateWrapper.set(OddApplyEntity::getOddId, entity.getId());
            updateWrapper.eq(OddApplyEntity::getId, entity.getOddApplyId());
            oddApplyService.update(updateWrapper);
        }
        if (fileIds != null && fileIds.size() > 0) {                     // 4、实体字段是否为空的判断，用于关联文件
            fileApi.updateAttachRef(entity.getId(), fileIds);
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<OddRedirectEntity> dddRedirectEntityes = redirectService.queryList(queryParam, false); // 6、查询出转扣实体数据

        if (dddRedirectEntityes != null && dddRedirectEntityes.size() > 0) {
            entity.setRedirectFlag(1);
            BigDecimal zkmny = new BigDecimal("0");             // 7、查询出转扣实体之后，即可计算转扣金额的总和
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = ComputeUtil.safeAdd(zkmny, oddRedirectEntity.getMny());
            }
            entity.setZkmny(zkmny);
        } else {
            entity.setRedirectFlag(0);
            entity.setZkmny(null);
        }

        saveOrUpdate(entity);
        OddVO vo = BeanMapper.map(entity, OddVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    private boolean syncApplyFile(Long oddApplyId, Long oddId) {
        List<AttachmentVO> returnAttachList = new ArrayList<>();
        CommonResponse<List<AttachmentVO>> attachmentRes = attachmentApi.queryListBySourceId(oddApplyId, "BT201123000000001", "oddapply", null);
        if(attachmentRes.isSuccess() && CollectionUtils.isNotEmpty(attachmentRes.getData())){
            List<AttachmentVO> oddApplyAttachmentList = attachmentRes.getData();
            for (AttachmentVO applyAttach : oddApplyAttachmentList) {
                applyAttach.setSourceId(oddId);
                applyAttach.setBillType("BT201123000000002");
                applyAttach.setSourceType("odd");
                applyAttach.setId(null);
                applyAttach.setCreateUserCode(null);
                applyAttach.setCreateTime(null);
                applyAttach.setUpdateUserCode(null);
                applyAttach.setUpdateTime(null);
            }
            CommonResponse<String> flag = attachmentApi.insertBatch(oddApplyAttachmentList);
            if(!flag.getMsg().equals("新增成功") ){
                throw new BusinessException(flag.getMsg());
            }
        }
        return true;
    }

    private void dealInfo(List<OddInfoVO> oddInfoVOS) {
        if (CollectionUtils.isNotEmpty(oddInfoVOS)) {
            for (OddInfoVO infoVO : oddInfoVOS) {
                infoVO.setNum(infoVO.getNum() == null ? BigDecimal.ZERO : infoVO.getNum());
            }
        }
    }

    private void isEnter(List<OddInfoVO> infoVOList) {
        if (CollectionUtils.isEmpty(infoVOList)) {
            throw new BusinessException("子表不能为空");
        }
        for (OddInfoVO vo : infoVOList) {
            if (vo.getName() == null || vo.getName().length() <= 0) {
                throw new BusinessException("用工项不能为空");
            }
            if (vo.getNum() == null) {
                throw new BusinessException("清单数量不能为空");
            }
            if (vo.getCode() == null || vo.getCode().length() <= 0) {
                throw new BusinessException("清单编码不能为空");
            }
            if (vo.getInfoUnit() == null || vo.getInfoUnit().length() <= 0) {
                throw new BusinessException("单位不能为空");
            }
            if (vo.getPrice() == null) {
                throw new BusinessException("无税单价不能为空");
            }
            if (vo.getBeginTime() == null) {
                throw new BusinessException("开始时间不能为空");
            }
            if (vo.getEndTime() == null) {
                throw new BusinessException("结束时间不能为空");
            }
        }
    }



    @Override
    public void del(List<OddVO> vos) {
        List<Long> list = vos.stream().map(OddVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, list));
        List<OddEntity> oddEntities = super.queryList(queryParam, false);
        List<Long> ids = new ArrayList<>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() == 2) {
                throw new BusinessException("供方同步的零工单不允许删除");
            }
            if (entity.getSourceType() == 0) {
                ids.add(entity.getOddApplyId());
            }
        }
        if (ids.size() > 0) {
            LambdaQueryWrapper<OddApplyEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(OddApplyEntity::getDr, 0);
            lambda.in(OddApplyEntity::getId, ids);
            List<OddApplyEntity> applyEntities = oddApplyService.list(lambda);
            List<Long> pkOddApplyList = new ArrayList<>();
            for (OddApplyEntity applyEntity : applyEntities) {
                if (applyEntity.getPassFlag() != null && applyEntity.getPassFlag() != -1) {
                    pkOddApplyList.add(applyEntity.getId());
                }
            }

            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, 0);
            updateWrapper.set(OddApplyEntity::getOddId, null);
            updateWrapper.in(OddApplyEntity::getId, ids);
            oddApplyService.update(updateWrapper);

            if (pkOddApplyList.size() > 0) {
                // 同步供方
                String url = wjOddApplyBatchNoUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOddApplyList(pkOddApplyList);
                writeBackApplyToSupl(request, url);
            }
        }

    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = this.selectById(id);
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = BeanMapper.map(entity, OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<OddInfoVO> oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<OddRedirectEntity> redirectEntities = redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList(redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public List<OddDetailVO> queryDetailsList(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public List<OddDetailVO> queryDetailsListConcat(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsListConcat(page, queryWrapper);
    }

    @Override
    public OddDetailVO queryRedirect(Long infoId) {
        return baseMapper.queryRedirect(infoId);
    }

    //同步nc是否已结算
    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        List<Long> yinfo = vo.getYinfo();
        List<Long> ninfo = vo.getNinfo();
        List<Long> yredirect = vo.getYredirect();
        List<Long> nredirect = vo.getNredirect();

        if (yinfo != null && yinfo.size() > 0) {
            LambdaUpdateWrapper<OddInfoEntity> yupdateWrapper = new LambdaUpdateWrapper<>();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag, 1);
            yupdateWrapper.in(OddInfoEntity::getId, yinfo);
            oddInfoService.update(yupdateWrapper);
        }
        if (ninfo != null && ninfo.size() > 0) {
            LambdaUpdateWrapper<OddInfoEntity> nupdateWrapper = new LambdaUpdateWrapper<>();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag, 0);
            nupdateWrapper.in(OddInfoEntity::getId, ninfo);
            oddInfoService.update(nupdateWrapper);
        }
        if (yredirect != null && yredirect.size() > 0) {
            LambdaUpdateWrapper<OddRedirectEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, 1);
            tupdateWrapper.in(OddRedirectEntity::getId, yredirect);
            redirectService.update(tupdateWrapper);
        }
        if (nredirect != null && nredirect.size() > 0) {
            LambdaUpdateWrapper<OddRedirectEntity> fupdateWrapper = new LambdaUpdateWrapper<>();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, 0);
            fupdateWrapper.in(OddRedirectEntity::getId, nredirect);
            redirectService.update(fupdateWrapper);
        }
        //都改成是
        Set<Long> yids = new HashSet<>();
        if (yinfo != null && yinfo.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yinfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if (yredirect != null && yredirect.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    yids.add(redirectEntity.getOddId());
                }
            }
        }
        if (yids != null && yids.size() > 0) {
            LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddEntity::getSettleNcFlag, 1);
            updateWrapper.in(OddEntity::getId, yids);
            super.update(updateWrapper);
        }

        //看情况改成否
        Set<Long> nids = new HashSet<>();
        if (ninfo != null && ninfo.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ninfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if (nredirect != null && nredirect.size() > 0) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, nredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    nids.add(redirectEntity.getOddId());
                }
            }
        }
        if (nids != null && nids.size() > 0) {
            List<Long> longList = baseMapper.querySettleFlag(new ArrayList<>(nids));
            List<Long> oddids = new ArrayList<>();
            Set<Long> set = new HashSet<>(longList);
            for(Long id : nids){
                if (!set.contains(id)) {
                    oddids.add(id);
                }
            }
            if (oddids != null && oddids.size() > 0) {
                LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(OddEntity::getSettleNcFlag, 0);
                updateWrapper.in(OddEntity::getId, oddids);
                super.update(updateWrapper);
            }
        }
        return CommonResponse.success("同步成功！");
    }

    @Override
    public Boolean suplInsert(com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billType = BillCons.ODD_BILL_TYPE;
        OddEntity entity = null;
        String applyCreateUserCode = null;
        if (null != request.getPkOddApply()) {
            OddApplyEntity applyEntity = oddApplyService.selectById(request.getPkOddApply());
            applyCreateUserCode = applyEntity.getCreateUserCode();
            entity = BeanMapper.map(applyEntity, OddEntity.class);
            entity.setOddApplyId(request.getPkOddApply());
            entity.setOddApplyBillCode(applyEntity.getBillCode());
        }else {
            entity = new OddEntity();
            entity.setContractId(request.getPkContract());
            entity.setContractCode(request.getContractCode());
            entity.setContractName(request.getContractName());
            entity.setUseDesc(request.getOddDesc());
            entity.setUseMny(request.getPricesum());
            entity.setReviewMny(request.getSumcheck());
            entity.setUseType(Long.valueOf("1330815360484229121"));
            entity.setUseTypeName("零星用工");
            entity.setBelong(Long.valueOf("1330815675283521538"));
            entity.setBelongName("维修");
            entity.setPlanBody(request.getPlanBody());
            CommonResponse<ProjectRegisterVO> response = projectApi.queryProjectBySourceId(request.getPkProject());
            if (response.isSuccess() && null != response.getData()) {
                ProjectRegisterVO registerVO = response.getData();
                entity.setProjectId(registerVO.getId());
                entity.setProjectName(registerVO.getName());
                entity.setProjectSourceId(registerVO.getSourceId());
                entity.setRealCorpId(registerVO.getRealCorpId());
                entity.setRealNcCorp(registerVO.getRealNcCorp());
                entity.setRealCorpName(registerVO.getRealCorpName());
                entity.setOrgId(registerVO.getProjectDepartmentId());
                entity.setOrgName(registerVO.getName());
                entity.setOrgSourceId(registerVO.getSourceId());

                CommonResponse<OrgVO> response1 = orgApi.getOneById(registerVO.getOrgId());
                if (response1.isSuccess() && null != response1.getData()) {
                    OrgVO orgVO = response1.getData();
                    entity.setCropId(orgVO.getId());
                    entity.setCropName(orgVO.getName());
                    entity.setCropSourceId(orgVO.getSourceId());
                }else {
                    throw new BusinessException("查询组织信息失败！");
                }
            }else {
                throw new BusinessException("查询项目信息失败！");
            }
            CommonResponse<SupplierVO> commonResponse = supplierApi.queryBySourceId(request.getPkSupplier());
            if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                SupplierVO supplierVO = commonResponse.getData();
                entity.setSupplierId(String.valueOf(supplierVO.getId()));
                entity.setSupplierName(supplierVO.getName());
                entity.setSupplierSourceId(request.getPkSupplier());
            }else {
                throw new BusinessException("查询供应商信息失败！");
            }
        }
        // 根据申请单主键查询申请单
        entity.setId(null);
        entity.setBillCode(request.getOddCode());
        try {
            entity.setCreateDate(sdf.parse(request.getCreateDate()));
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        entity.setUseMny(request.getPricesum());
        entity.setReviewMny(request.getSumcheck());
        entity.setSourceType(2);
        entity.setOddStatus(1);// 已提交
        entity.setBillState(0);// 自由态
        entity.setRedirectFlag(request.getRedirectStatus());
        entity.setCreateName(request.getName());
        entity.setSettleNcFlag(0);
        entity.setOddSource(0);
        entity.setImportFlag(0);
        entity.setSourceId(request.getPkOdd());
        entity.setZkmny(request.getSumredirect());
        super.saveOrUpdate(entity);
        // 处理子表，先删后增（防止多次提交的问题）
        List<com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO> oddInfoList = request.getOddInfoList();
        if (oddInfoList != null && oddInfoList.size() > 0) {
            List<OddInfoEntity> oddInfoEntities = new ArrayList<>();
            for (com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo : oddInfoList) {
                OddInfoEntity oddInfoEntity = mapInfo(vo, entity.getId());
                oddInfoEntities.add(oddInfoEntity);

                // 处理用工前后附件
                List<FileRelation> befFileList = vo.getBefFileList();
                List<FileRelation> aftFileList = vo.getAftFileList();
                List<AttachmentVO> fileList = new ArrayList<>();
                if (befFileList != null && befFileList.size() > 0) {
                    for (FileRelation f : befFileList) {
                        AttachmentVO file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("before_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(10123L);
                        fileList.add(file);
                    }
                }
                if (aftFileList != null && aftFileList.size() > 0) {
                    for (FileRelation f : aftFileList) {
                        AttachmentVO file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("after_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(10123L);
                        fileList.add(file);
                    }
                }
                if (fileList.size() > 0) {
                    // 保存附件
                    attachmentApi.insertBatch(fileList);
                }
            }
            oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        }

        if (null != entity.getOddApplyId()) {
            // 回写申请单是否被引用
            writeBackApply(entity.getId(), entity.getOddApplyId(), true);
            // 信息发送类型
            List<String> messageType = new ArrayList<>();
            messageType.add("sys");
            messageType.add("wjyOdd");
            String subject = "供应商【"+entity.getSupplierName()+"】提交的【零星用工审批单_"+entity.getBillCode()+"_" + sdf.format(new Date()) + "】需要确认或驳回";
            //subject = "你提交的流程【零星用工_" + applyEntity.getBillCode() + "_" + sdf.format(new Date()) + "】已被供应商【" + request.getManagname() + "】确认";
            List<String> sender = new ArrayList<>();
            String createUserId = msgUtil.getCreateUserId(applyCreateUserCode);
            sender.add(createUserId);
            String formurl = baseHost + "cscec5b-fbxt-frontend/#/odd/card?id=" + entity.getId();
            String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            msgUtil.sendMsg(messageType, sender, "task", subject, content,entity.getId());
        }
        return true;
    }

    @Override
    public Boolean confirmSupply(OddVO request, Integer oddStatus) {
        OddEntity odd = super.selectById(request.getId());
        if (BillStatusEnum.确认驳回.getCode() == oddStatus) {
            // 删除
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            if (null != odd.getOddApplyId()) {
                writeBackApply(odd.getId(), odd.getOddApplyId(), false);
            }
            // sendToSuplNotice(odd, false); // 改为供方发消息
            super.removeById(request.getId());
            sendMsg(odd, oddStatus);
        } else {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            super.saveOrUpdate(odd);
        }
        return true;
    }

    // 数据结构转换
    private OddInfoEntity mapInfo(com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo, Long oddId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddInfoEntity res = new OddInfoEntity();
        if (null != vo.getPkApplyInfo()) {
            OddInfoApplyEntity oddInfoApplyEntity = oddInfoApplyService.selectById(vo.getPkApplyInfo());
            res.setSourceType(oddInfoApplyEntity.getSourceType()); // 来源类型，0--引用，1-手工新增
            res.setSourceId(oddInfoApplyEntity.getSourceId()); // 来源主键
            res.setInfoApplyId(vo.getPkApplyInfo());
            res.setPkMeasdoc(oddInfoApplyEntity.getPkMeasdoc());
        }else {
            res.setSourceType(0); // 来源类型，0--引用，1-手工新增
            res.setSourceId(vo.getSourceId());
            res.setPkAmountlist(vo.getPkAmountlist());
            res.setHtywnr(vo.getHtywnr());
            res.setPkMeasdoc(vo.getPkMeasdoc());
        }
        res.setId(null);
        res.setOddId(oddId);

        res.setName(vo.getInfoName());
        res.setNum(vo.getInfoAmount());
        res.setApplyNum(vo.getApplyAmount()); // 申请数量，申请制单才有
        res.setPrice(vo.getUnitPrice()); // 无税单价
        res.setMny(vo.getSumPrice()); // 金额
        res.setCode(vo.getInfoCode()); // 清单编码
        res.setInfoUnit(vo.getInfoUnit()); // 单位
        res.setReviewNum(vo.getInfoAmountCheck()); // 审核数量
        res.setReviewPrice(vo.getUnitPriceCheck()); // 审核单价
        res.setReviewMny(vo.getSumPriceCheck()); // 审核金额
        try {
            res.setBeginTime(sdf.parse(vo.getBeginTime())); // 开始时间
            res.setEndTime(sdf.parse(vo.getEndTime())); // 开始时间
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        res.setZkcontract(null); // 转扣合同
        res.setZkcorpname(null); // 转扣单位
        res.setSumRedirectMny(BigDecimal.ZERO); // 累计转扣金额
        res.setFileType(String.valueOf(IdWorker.getId())); // 附件唯一标识,这里是为附件做准备
        res.setInfoNcFlag(0); // nc是否结算，0-否，1-是
        return res;
    }

    // 回写申请单是否被引用
    private void writeBackApply(Long pkOdd, Long pkOddApply, boolean isUsed) {
        ApplyRequest request = new ApplyRequest();
        request.setPkOddApply(pkOddApply);
        if (isUsed) {
            request.setPkOdd(pkOdd);
        } else {
            request.setIsused(0);
        }
        oddApplyService.applyUsed(request);
    }

    // 是否引用推送供方
    private void writeBackApplyToSupl(ApplyRequest request, String url) {

        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = oddApplyUsed(headers, request, url);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    @Override
    public void sendMsg(OddEntity odd, Integer oddStatus) {
        OddWriteBackRequest request = new OddWriteBackRequest();
        request.setPkOdd(odd.getSourceId());
        request.setSourceId(odd.getId());
        request.setOddStatus(oddStatus);
        request.setConfirmer(odd.getConfirmer());
        request.setConfirmerName(odd.getConfirmerName());
        request.setConfirmerNote(odd.getConfirmerNote());

        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = pushOddJob(headers, request);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    @Override
    public Map<Long, String> queryDefDoc(String useTypeDefCode) {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = defdocApi.queryDetailListByDefdocCode(useTypeDefCode, null);
        if (listCommonResponse.isSuccess()) {
            List<Map<String, Object>> data = listCommonResponse.getData();
            Map<Long, String> docMap = new HashMap<>();
            for (Map<String, Object> map : data) {
                docMap.put(Long.parseLong(map.get("id").toString()), map.get("name").toString());
            }
            return docMap;
        } else {
            throw new BusinessException("查询自定义档案失败!");
        }
    }

    @Override
    public CommonResponse<String> pushToNc(Long id) {
        if (baseHost.contains("9080")) {
            //1是直审，2是有审批流
            logger.info("---------------------------数据同步至nc");

            OddVO oddVO = queryDetail(id);
            com.ejianc.business.sync.vo.OddVO map = BeanMapper.map(oddVO, com.ejianc.business.sync.vo.OddVO.class);

            List<OddInfoVO> oddInfoEntities = oddVO.getOddInfoEntities();
            List<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<>();
            for (OddInfoVO info : oddInfoEntities) {
                List<OddRedirectVO> oddRedirectEntities = info.getOddRedirectEntities();
                List<com.ejianc.business.sync.vo.OddRedirectVO> redirectVO = BeanMapper.mapList(oddRedirectEntities, com.ejianc.business.sync.vo.OddRedirectVO.class);
                com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = BeanMapper.map(info, com.ejianc.business.sync.vo.OddInfoVO.class);
                oddInfoVO.setOddRedirectEntities(redirectVO);
                list.add(oddInfoVO);
            }
            map.setOddInfoEntities(list);
            logger.info("主表来源1：" + oddVO.getOddSource());
            logger.info("主表来源2：" + map.getOddSource());
            map.setOddSource(oddVO.getOddSource());
            CommonResponse<com.ejianc.business.sync.vo.OddVO> response = oddSyncApi.syncOdd(map);
            logger.info("+++++++++++++++++++++++++++数据同步至nc");
            if (response.isSuccess()) {
                com.ejianc.business.sync.vo.OddVO data = response.getData();
                if (CollectionUtils.isNotEmpty(data.getOddInfoEntities())) {
                    List<OddInfoEntity> infoEntities = new ArrayList<>();
                    for(com.ejianc.business.sync.vo.OddInfoVO oddInfoVO : data.getOddInfoEntities()){
                        if(1 == oddInfoVO.getSourceType()){
                            infoEntities.add(BeanMapper.map(oddInfoVO, OddInfoEntity.class));
                        }
                    }
                    if (CollectionUtils.isNotEmpty(infoEntities)) {
                        oddInfoService.updateBatchById(infoEntities, infoEntities.size());
                    }
                }
                return CommonResponse.success();
            } else {
                return CommonResponse.error("数据同步至nc失败");
            }
        }
        return CommonResponse.success("啥也没干");
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> pushOddJob(Map<String, String> headers, OddWriteBackRequest copy) {
        String url = wjOddJobUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }

    public CommonResponse<String> oddApplyUsed(Map<String, String> headers, ApplyRequest copy, String url) {
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }

    public CommonResponse<String> pushPcaOdd(Map<String, String> headers, PcaOdd copy) {
        String url = wjOddPcaUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }

    public CommonResponse<String> delPcaOdd(Map<String, String> headers, PcaOdd copy) {
        String url = wjOddPcaDelUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }


    @Override
    public CommonResponse<String> confirmState(String oddId,Integer confirmState) {
        LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OddEntity::getId, oddId);
        updateWrapper.set(OddEntity::getConfirmState,confirmState);
        boolean flag = update(updateWrapper);
        if(flag){
            return CommonResponse.success("供方确认成功！");
        }else{
            return CommonResponse.success("供方确认失败！");
        }

    }

    @Override
    public void pushOdd(OddVO odd ) {
        PcaOdd pcaOdd = oddorPcaOdd(odd);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = pushPcaOdd(headers, pcaOdd);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    @Override
    public void delPcaOdd(OddVO odd ) {
        PcaOdd pcaOdd = oddorPcaOdd(odd);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = delPcaOdd(headers, pcaOdd);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }


    public PcaOdd oddorPcaOdd(OddVO odd ) {
        PcaOdd pcaOdd = new PcaOdd();
        pcaOdd.setPkOdd(odd.getId().toString());
        pcaOdd.setBillCode(odd.getBillCode());
        pcaOdd.setProjectId(odd.getProjectId().toString());
        pcaOdd.setProjectName(odd.getProjectName());
        pcaOdd.setProjectSourceId(odd.getProjectSourceId());
        pcaOdd.setOrgId(odd.getOrgId().toString());
        pcaOdd.setOrgSourceId(odd.getOrgSourceId());
        pcaOdd.setOrgName(odd.getOrgName());
        pcaOdd.setContractId(odd.getContractId());
        pcaOdd.setContractName(odd.getContractName());
        pcaOdd.setContractCode(odd.getContractCode());
        pcaOdd.setSupplierId(odd.getSupplierSourceId());
        pcaOdd.setSupplierName(odd.getSupplierName());
        pcaOdd.setCreateDate(odd.getCreateDate());
        pcaOdd.setUseTypeName(odd.getUseTypeName());
        pcaOdd.setBelongName(odd.getBelongName());
        pcaOdd.setPlanBody(odd.getPlanBody());
        pcaOdd.setUseDesc(odd.getUseDesc());
        pcaOdd.setUseMny(odd.getUseMny());
        pcaOdd.setReviewMny(odd.getReviewMny());
        pcaOdd.setSourceType(odd.getSourceType());
        pcaOdd.setOddApplyId(odd.getOddApplyId()== null ? null : odd.getOddApplyId().toString());
        pcaOdd.setOddApplyBillCode(odd.getOddApplyBillCode() == null ? null : odd.getOddApplyBillCode().toString());
        pcaOdd.setOddStatus(odd.getOddStatus());
        pcaOdd.setBillState(odd.getBillState());
        pcaOdd.setRedirectFlag(odd.getRedirectFlag());
        pcaOdd.setCreateName(odd.getCreateName());
        pcaOdd.setSettleNcFlag(odd.getSettleNcFlag());
        pcaOdd.setOddSource(odd.getOddSource());
        pcaOdd.setImportFlag(odd.getImportFlag());
        pcaOdd.setMemo(odd.getMemo());
        pcaOdd.setRealCorpId(odd.getRealCorpId()== null ? null : odd.getRealCorpId().toString());
        pcaOdd.setRealNcCorp(odd.getRealNcCorp());
        pcaOdd.setRealCorpName(odd.getRealCorpName());
        pcaOdd.setSourceId(odd.getId().toString());
        pcaOdd.setConfirmer(odd.getConfirmer());
        pcaOdd.setConfirmerName(odd.getConfirmerName());
        pcaOdd.setConfirmFlag(0);//未确认
        pcaOdd.setConfirmerNote(odd.getConfirmerNote());
        pcaOdd.setZkmny(odd.getZkmny());
        pcaOdd.setSumSettle(odd.getSumSettle());
        pcaOdd.setCreateTime(odd.getCreateTime());
        pcaOdd.setUpdateTime(odd.getUpdateTime());
        pcaOdd.setTs(new Date());

        if(pcaOdd.getProjectSourceId()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse =  projectApi.queryProjectBySourceId(pcaOdd.getProjectSourceId());
            if(ponse.getData()==null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            ProjectRegisterVO projectRegisterVO = ponse.getData();
            pcaOdd.setCorpId(projectRegisterVO.getOrgId());//项目所属组织id
            pcaOdd.setCorpName(projectRegisterVO.getOrgName());
            pcaOdd.setCorpSourceId(projectRegisterVO.getSourceOrgId());//项目所属组织来源id
        }

        if(CollectionUtils.isNotEmpty(odd.getOddInfoEntities())){
            pcaOdd.setOddInfoList(oddInfoorPcaOddInfo(odd.getOddInfoEntities()));
        }
        return pcaOdd;
    }

    public List<PcaOddInfo> oddInfoorPcaOddInfo(List<OddInfoVO> oddInfoVOList ) {
        List<PcaOddInfo> pcaOddInfoList = new ArrayList<>();
        for(OddInfoVO odd : oddInfoVOList) {
            PcaOddInfo pcaOdd = new PcaOddInfo();
            pcaOdd.setPkOddInfo(odd.getId().toString());
            pcaOdd.setPkOdd(odd.getOddId().toString());
            pcaOdd.setInfoApplyId(odd.getInfoApplyId() == null ? null : odd.getInfoApplyId().toString());
            pcaOdd.setName(odd.getName());
            pcaOdd.setNum(odd.getNum());
            pcaOdd.setApplyNum(odd.getApplyNum());
            pcaOdd.setPrice(odd.getPrice());
            pcaOdd.setMny(odd.getMny());
            pcaOdd.setCode(odd.getCode());
            pcaOdd.setInfoUnit(odd.getInfoUnit());
            pcaOdd.setReviewNum(odd.getReviewNum());
            pcaOdd.setReviewPrice(odd.getReviewPrice());
            pcaOdd.setReviewMny(odd.getReviewMny());
            pcaOdd.setSourceType(odd.getSourceType());
            pcaOdd.setFirstApply(odd.getFirstApply());
            pcaOdd.setSourceId(odd.getId().toString());
            pcaOdd.setBeginTime(odd.getBeginTime());
            pcaOdd.setEndTime(odd.getEndTime());
            pcaOdd.setZkcontract(odd.getZkcontract());
            pcaOdd.setZkcorpname(odd.getZkcorpname());
            pcaOdd.setSumRedirectMny(odd.getSumRedirectMny());
            pcaOdd.setFileType(odd.getFileType());
            pcaOdd.setInfoNcFlag(odd.getInfoNcFlag());
            pcaOdd.setPkMeasdoc(odd.getPkMeasdoc());
            pcaOdd.setPkAmountlist(odd.getPkAmountlist());
            pcaOdd.setHtywnr(odd.getHtywnr());
            pcaOdd.setTs(new Date());
            pcaOddInfoList.add(pcaOdd);
        }

        return pcaOddInfoList;
    }
}
