/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.comment.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.comment.bean.MatSyncRecordEntity;
import com.ejianc.business.fbxt.comment.service.IMatSyncRecordService;
import com.ejianc.business.fbxt.comment.vo.MatSyncRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/matsync"})
public class MatSyncRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSyncRecordService service;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/insertBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> insert(@RequestBody List<MatSyncRecordVO> recordVOList) {
        List list = BeanMapper.mapList(recordVOList, MatSyncRecordEntity.class);
        for (MatSyncRecordEntity recordEntity : list) {
            recordEntity.setCorpName(((OrgVO)this.orgApi.findBySourceId(recordEntity.getPkCorp()).getData()).getName());
        }
        this.service.saveOrUpdateBatch(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSyncRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatSyncRecordVO matSyncRecordVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatSyncRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("corpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSyncRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/updateSyncFlag"})
    @ResponseBody
    public CommonResponse<String> updateSyncFlag(@RequestParam(value="id") Long id, @RequestParam(value="syncFlag") Integer syncFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(MatSyncRecordEntity::getSyncFlag, (Object)syncFlag);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u540c\u6b65\u72b6\u6001\u6210\u529f\uff01");
    }
}

