/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sumGrap"})
public class SumGrapController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISumGrapService service;
    @Autowired
    private IGrapService grapService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SumGrapVO> saveOrUpdate(@RequestBody SumGrapVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumGrapVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SumGrapVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(GrapEntity::getSumGrapId, ids);
        updateWrapper.set(GrapEntity::getBillState, (Object)0);
        updateWrapper.set(GrapEntity::getSumGrapId, null);
        this.grapService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SumGrapVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else if (param.getParams().containsKey("realCorpId")) {
                param.getParams().put("cropId", new Parameter("in", param.getParams().get("realCorpId")));
            } else {
                param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (param.getParams().containsKey("sumApproveMny")) {
            param.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SumGrapVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SumGrapVO>> res = this.queryList(param);
        List list = new ArrayList();
        if (res.isSuccess() && res.getData() != null && CollectionUtils.isNotEmpty((Collection)((IPage)res.getData()).getRecords())) {
            list = ((IPage)res.getData()).getRecords();
            list.forEach(vo -> {
                String useStateName = "";
                useStateName = vo.getUseState() != null && vo.getUseState() == 1 ? "\u662f" : "\u5426";
                vo.setUseStateName(useStateName);
                if (vo.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) {
                    vo.setSumApproveMny(null);
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("sumGrap-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/syncUseState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse syncUseState(HttpServletRequest request) {
        return this.service.syncUseState(request);
    }

    @GetMapping(value={"/sumGrapUpdateState"})
    @ResponseBody
    public CommonResponse<String> sumGrapUpdateState(@RequestParam(value="id") String id, @RequestParam(value="confirmFlag") Integer confirmFlag) {
        return this.service.confirmFlagUpdate(id, confirmFlag);
    }

    @RequestMapping(value={"/handlePrintDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody JSONObject jsonObject) {
        this.logger.info("\u65e5\u5fd7\u53f0\u8d26\u6253\u5370\u6a21\u677f\u6570\u636e\u5904\u7406\uff0c\u5165\u53c2--{}", (Object)jsonObject.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        JSONObject detailJson = jsonObject.getJSONObject("detailJson");
        this.logger.info("\u65e5\u5fd7\u53f0\u8d26\u6253\u5370\u6a21\u677f\u6570\u636e\u5904\u7406\uff0cdetailJson--{}", (Object)JSON.toJSONString((Object)detailJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (null == detailJson) {
            return CommonResponse.success();
        }
        this.service.handlePrintDetail(detailJson);
        this.logger.info("\u5904\u7406\u5b8c\u6210\uff0cdetailJson--{}", (Object)JSON.toJSONString((Object)detailJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((Object)detailJson);
    }
}

