/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.news.bean.NewsEntity;
import com.ejianc.business.fbxt.news.bean.NewsSupplierEntity;
import com.ejianc.business.fbxt.news.mapper.NewsMapper;
import com.ejianc.business.fbxt.news.service.INewsService;
import com.ejianc.business.fbxt.news.vo.News;
import com.ejianc.business.fbxt.news.vo.NewsSupplierVO;
import com.ejianc.business.fbxt.news.vo.NewsVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="newsService")
public class NewsServiceImpl
extends BaseServiceImpl<NewsMapper, NewsEntity>
implements INewsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "FBXT_NEWS";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.newsInsertUrl}")
    private String newsInsertUrl;
    @Value(value="${openApi.newsDelUrl}")
    private String newsDelUrl;
    @Value(value="${openApi.newsPageUrl}")
    private String newsPageUrl;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public NewsVO queryDetail(Long id) {
        NewsEntity entity = (NewsEntity)((Object)this.selectById(id));
        NewsVO vo = (NewsVO)((Object)BeanMapper.map((Object)((Object)entity), NewsVO.class));
        return vo;
    }

    @Override
    public JSONObject queryRecordList(QueryParam param) {
        String pkNews = String.valueOf(((Parameter)param.getParams().get("pkNews")).getValue());
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            JSONObject query = new JSONObject();
            query.put("pkNews", (Object)pkNews);
            query.put("page", (Object)param.getPageIndex());
            query.put("rows", (Object)param.getPageSize());
            query.put("text", (Object)param.getSearchText());
            try {
                this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                JSONObject jsonBack = JSONObject.parseObject((String)HttpTookit.postByJson(this.newsPageUrl, query.toString(), headers));
                this.logger.info("---\u56de\u53c2:" + jsonBack);
                if ("200".equals(jsonBack.getString("code"))) {
                    return jsonBack;
                }
                throw new BusinessException("\u67e5\u8be2\u4f9b\u65b9\u8bb0\u5f55\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new BusinessException("\u67e5\u8be2\u4f9b\u65b9\u8bb0\u5f55\u5931\u8d25");
            }
        }
        return null;
    }

    @Override
    public CommonResponse<String> pushToSupplier(Long id) {
        NewsEntity newsEntity = (NewsEntity)((Object)this.selectById(id));
        newsEntity.setPublishTime(new Date());
        this.saveOrUpdate((Object)newsEntity);
        News news = (News)BeanMapper.map((Object)((Object)newsEntity), News.class);
        news.setPkNews(String.valueOf(id));
        if (CollectionUtils.isNotEmpty(newsEntity.getDetailList())) {
            List supplierList = newsEntity.getDetailList().stream().map(NewsSupplierEntity::getSourceSupplierId).collect(Collectors.toList());
            news.setPkSupplier(StringUtils.join(supplierList, (String)"@"));
        }
        ArrayList<FileRelation> orderfileList = new ArrayList<FileRelation>();
        CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(id, "BT231019000000001", "news", null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
            List fileList = (List)fileResponse.getData();
            for (AttachmentVO fileVo : fileList) {
                FileRelation file = new FileRelation();
                file.setFileName(fileVo.getFileName());
                file.setFilePath(fileVo.getFilePath());
                file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                file.setFileBizPk(String.valueOf(id));
                file.setDr(Integer.valueOf(0));
                file.setFileBiz("news");
                file.setBizType("0");
                orderfileList.add(file);
            }
        }
        news.setFileList(orderfileList);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            try {
                this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                JSONObject jsonBack = JSONObject.parseObject((String)HttpTookit.postByJson(this.newsInsertUrl, JSONObject.toJSON((Object)news).toString(), headers));
                this.logger.info("---\u56de\u53c2:" + jsonBack);
                if (!"200".equals(jsonBack.getString("code"))) {
                    return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u4f9b\u65b9\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> deleteSupplier(Long id) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            try {
                this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", String.valueOf(id));
                JSONObject jsonBack = JSONObject.parseObject((String)HttpTookit.get(this.newsDelUrl, map, headers));
                this.logger.info("---\u56de\u53c2:" + jsonBack);
                if (!"200".equals(jsonBack.getString("code"))) {
                    return CommonResponse.error((String)"\u5220\u9664\u4f9b\u65b9\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return CommonResponse.error((String)"\u5220\u9664\u4f9b\u65b9\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u4f9b\u65b9\u6210\u529f\uff01");
    }

    @Override
    public NewsVO saveOrUpdate(NewsVO saveOrUpdateVO) {
        UserContext userContextCache = this.sessionManager.getUserContext();
        NewsEntity entity = (NewsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), NewsEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setPublishUser(userContextCache.getUserName());
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            List supplierList = saveOrUpdateVO.getDetailList().stream().map(NewsSupplierVO::getSupplierName).collect(Collectors.toList());
            entity.setSupplierName(StringUtils.join(supplierList, (String)","));
        }
        this.saveOrUpdate((Object)entity, false);
        NewsVO vo = (NewsVO)((Object)BeanMapper.map((Object)((Object)entity), NewsVO.class));
        return vo;
    }

    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }
}

