package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.fjwz.vo.DisposeDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 处置申请
 * 
 * @author generator
 * 
 */
public class DisposeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 所属单位主键
    private String orgName; // 所属单位名称
    private String orgCode; // 所属单位编码
    private String materialTypeNames; // 物料分类名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 处置时间
    private String memo; // 备注
    private String projectSourceId; // 项目来源ID
    private Long parentOrgId; // 上级组织id
    private String parentOrgSourceId; // 上级组织来源id
    private String parentOrgName; // 上级组织name
    private String billStateName; //
    
    private List<DisposeDetailVO> disposeDetailList = new ArrayList<>(); // 处置申请明细表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    
     public List<DisposeDetailVO> getDisposeDetailList() {
        return disposeDetailList;
     }

     public void setDisposeDetailList(List<DisposeDetailVO> disposeDetailList) {
        this.disposeDetailList = disposeDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
