package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 定标-主表
 * 
 * @author generator
 * 
 */
@ApiModel("定标-主表")
public class PicketageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("询价立项主键")
    private Long inviteId;
    @ApiModelProperty("上游单据主键")
    private Long billId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("定标名称")
    private String picketageName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目来源ID")
    private String projectSourceId;
    @ApiModelProperty("")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人name")
    private String employeeName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织name")
    private String orgName;
    @ApiModelProperty("父级组织id")
    private Long parentOrgId;
    @ApiModelProperty("组织来源id")
    private String orgSourceId;
    @ApiModelProperty("父级组织来源id")
    private String parentOrgSourceId;
    @ApiModelProperty("父级组织name")
    private String parentOrgName;
    @ApiModelProperty("定标日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date picketageTime;
    @ApiModelProperty("询价单位ID")
    private Long unitId;
    @ApiModelProperty("询价单位来源ID")
    private String unitSourceId;
    @ApiModelProperty("询价单位name")
    private String unitName;
    @ApiModelProperty("经办人ID")
    private Long trusteesId;
    @ApiModelProperty("经办人名称")
    private String trusteesName;
    @ApiModelProperty("询价联系人id")
    private Long doucumentLinkId;
    @ApiModelProperty("询价联系人name")
    private String doucumentLinkName;
    @ApiModelProperty("询价联系人电话")
    private String doucumentLinkMobile;
    @ApiModelProperty("默认中标供应商")
    private List<DocumentSupplierVO> supplierBidList = new ArrayList<>();
    @ApiModelProperty("报价供应商")
    private List<DocumentSupplierVO> supplierList = new ArrayList<>();

    public List<DocumentSupplierVO> getSupplierBidList() {
        return supplierBidList;
    }

    public void setSupplierBidList(List<DocumentSupplierVO> supplierBidList) {
        this.supplierBidList = supplierBidList;
    }

    public List<DocumentSupplierVO> getSupplierList() {
        return supplierList;
    }

    public void setSupplierList(List<DocumentSupplierVO> supplierList) {
        this.supplierList = supplierList;
    }

    /**
     * 询价立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 询价立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 定标名称
     */
    public String getPicketageName() {
        return picketageName;
    }

    /**
     * 定标名称
     */
    public void setPicketageName(String picketageName) {
        this.picketageName = picketageName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 经办人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人name
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人name
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织name
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织name
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织来源id
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源id
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 父级组织来源id
     */
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 父级组织来源id
     */
    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    /**
     * 父级组织name
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织name
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 定标日期
     */
    public Date getPicketageTime() {
        return picketageTime;
    }

    /**
     * 定标日期
     */
    public void setPicketageTime(Date picketageTime) {
        this.picketageTime = picketageTime;
    }
    /**
     * 询价单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 询价单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 询价单位来源ID
     */
    public String getUnitSourceId() {
        return unitSourceId;
    }

    /**
     * 询价单位来源ID
     */
    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    /**
     * 询价单位name
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 询价单位name
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 经办人ID
     */
    public Long getTrusteesId() {
        return trusteesId;
    }

    /**
     * 经办人ID
     */
    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }
    /**
     * 经办人名称
     */
    public String getTrusteesName() {
        return trusteesName;
    }

    /**
     * 经办人名称
     */
    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }
    /**
     * 询价联系人id
     */
    public Long getDoucumentLinkId() {
        return doucumentLinkId;
    }

    /**
     * 询价联系人id
     */
    public void setDoucumentLinkId(Long doucumentLinkId) {
        this.doucumentLinkId = doucumentLinkId;
    }
    /**
     * 询价联系人name
     */
    public String getDoucumentLinkName() {
        return doucumentLinkName;
    }

    /**
     * 询价联系人name
     */
    public void setDoucumentLinkName(String doucumentLinkName) {
        this.doucumentLinkName = doucumentLinkName;
    }
    /**
     * 询价联系人电话
     */
    public String getDoucumentLinkMobile() {
        return doucumentLinkMobile;
    }

    /**
     * 询价联系人电话
     */
    public void setDoucumentLinkMobile(String doucumentLinkMobile) {
        this.doucumentLinkMobile = doucumentLinkMobile;
    }
    
}
