/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.vo.DocumentRecordVO;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"document"})
@Api(value="\u8be2\u4ef7\u516c\u544a-\u4e3b\u8868", tags={"\u8be2\u4ef7\u516c\u544a-\u4e3b\u8868"})
public class DocumentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDocumentService service;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DocumentVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DocumentVO saveOrUpdateVO) {
        DocumentEntity entity = (DocumentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DocumentEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        DocumentVO documentVO = this.service.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)documentVO);
    }

    @ApiOperation(value="\u8be2\u4ef7\u7acb\u9879\u4e0b\u4e00\u6b65\u63a5\u53e3")
    @RequestMapping(value={"/saveDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocumentVO> saveDocument(@RequestParam Long inviteId) {
        DocumentVO documentVO = this.service.saveDocument(inviteId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)documentVO);
    }

    @ApiOperation(value="\u53d1\u5e03\u516c\u544a\u63a5\u53e3")
    @RequestMapping(value={"/publishDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocumentVO> publishDocument(@RequestParam Long id) throws Exception {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publishDocument(id));
    }

    @ApiOperation(value="\u4f9b\u65b9\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/supplierPushSell"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DocumentSupplierVO documentSupplierVO) {
        Boolean b = this.service.supplierPushSell(documentSupplierVO);
        return CommonResponse.success((String)"\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u6210\u529f\uff01", (Object)b);
    }

    @ApiOperation(value="\u6839\u636e\u8be2\u4ef7\u516c\u544a\u4e3b\u952e\u548c\u4f9b\u5e94\u5546\u4e3b\u952e\u67e5\u8be2\u8be6\u60c5\u63a5\u53e3(\u5355\u4e2a\u4f9b\u5e94\u5546)")
    @RequestMapping(value={"/getSellInfoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocumentSupplierVO> getSellInfoById(@RequestParam Long supplierId, @RequestParam Long documentId) {
        DocumentSupplierVO documentSupplierVO = this.service.getSellInfoById(supplierId, documentId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)documentSupplierVO);
    }

    @ApiOperation(value="\u5f00\u6807\u63a5\u53e3")
    @RequestMapping(value={"/bidDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocumentVO> bidDocument(@RequestParam Long id) {
        DocumentVO s = this.service.bidDocument(id);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)s);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocumentVO> queryDetail(@RequestParam Long id) {
        DocumentVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u63a5\u53e3")
    @RequestMapping(value={"/extendDocument"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DocumentVO> extendDocument(@RequestBody DocumentRecordVO documentRecordVO) {
        return CommonResponse.success((String)"\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\uff01", (Object)this.service.extendDocument(documentRecordVO));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocumentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DocumentVO documentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DocumentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DocumentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Document-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refDocumentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DocumentVO>> refDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DocumentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

