/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.bean.WasteEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.IInviteDetailService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.service.IWasteService;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.ProcessVO;
import com.ejianc.business.fjwz.vo.WasteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"waste"})
public class WasteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "WASTE";
    @Autowired
    private IWasteService service;
    @Autowired
    private IInviteDetailService inservice;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WasteVO> saveOrUpdate(@RequestBody WasteVO saveOrUpdateVO) {
        WasteEntity entity = (WasteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WasteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u4e2d\u6b62\u8be2\u4ef7");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setFrontendUrl("waste");
        this.processService.saveOrUpdate((Object)processEntity);
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getInviteId());
        updateWrapper.set(InviteEntity::getTenderStage, (Object)TenderStageEnum.WASTE.getChangeStateCode());
        updateWrapper.set(InviteEntity::getNextFlag, (Object)0);
        this.inviteService.update((Wrapper)updateWrapper);
        WasteVO vo = (WasteVO)BeanMapper.map((Object)((Object)entity), WasteVO.class);
        List list = this.inservice.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)entity.getInviteId()));
        vo.setDetailVOS(BeanMapper.mapList((Iterable)list, InviteDetailVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WasteVO> queryDetail(Long id) {
        WasteEntity entity = (WasteEntity)((Object)this.service.selectById(id));
        List list = this.inservice.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)entity.getInviteId()));
        WasteVO vo = (WasteVO)BeanMapper.map((Object)((Object)entity), WasteVO.class);
        vo.setDetailVOS(BeanMapper.mapList((Iterable)list, InviteDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WasteVO> vos) {
        int size;
        WasteEntity wasteEntity = (WasteEntity)((Object)this.service.selectById(vos.get(0).getId()));
        InviteEntity entity = (InviteEntity)((Object)this.inviteService.selectById(wasteEntity.getInviteId()));
        List<ProcessVO> processVOS = this.processService.queryProcess(wasteEntity.getInviteId());
        if (CollectionUtils.isNotEmpty(processVOS)) {
            processVOS.removeIf(vo -> vo.getBillId().equals(wasteEntity.getId()));
        }
        entity.setTenderStage(processVOS.get(size = processVOS.size()).equals("\u8be2\u4ef7\u7ed3\u679c") ? TenderStageEnum.PICKETAGE.getChangeStateCode() : (processVOS.get(size).equals("\u6d3d\u5546\u8c08\u5224") ? TenderStageEnum.TALK.getChangeStateCode() : TenderStageEnum.DOCUMENT.getChangeStateCode()));
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

