/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentRecordEntity;
import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.DocumentMapper;
import com.ejianc.business.fjwz.service.IDocumentRecordService;
import com.ejianc.business.fjwz.service.IDocumentSellService;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.DocumentRecordVO;
import com.ejianc.business.fjwz.vo.DocumentSellVO;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.InviteSupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="documentService")
public class DocumentServiceImpl
extends BaseServiceImpl<DocumentMapper, DocumentEntity>
implements IDocumentService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjOrderUrl}")
    private String wjOrderUrl;
    @Value(value="${openApi.wjDelOrderUrl}")
    private String wjDelOrderUrl;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public DocumentVO saveDocument(Long inviteId) {
        DocumentEntity entity = new DocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(inviteId));
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectSourceId(inviteEntity.getProjectSourceId());
        entity.setInviteId(inviteId);
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgSourceId(inviteEntity.getParentOrgSourceId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setDocumentName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setUnitSourceId(inviteEntity.getUnitSourceId());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        super.saveOrUpdate((Object)entity, false);
        inviteEntity.setTenderStage(TenderStageEnum.DOCUMENT.getChangeStateCode());
        inviteEntity.setNextFlag(1);
        this.inviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
        processEntity.setTenderId(inviteEntity.getId());
        processEntity.setFrontendUrl("document");
        this.processService.saveOrUpdate((Object)processEntity);
        DocumentVO vo = (DocumentVO)BeanMapper.map((Object)((Object)entity), DocumentVO.class);
        vo.setInviteDetailList(BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class));
        vo.setInviteSupplierList(BeanMapper.mapList(inviteEntity.getInviteSupplierlList(), InviteSupplierVO.class));
        return vo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DocumentVO publishDocument(Long id) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        documentEntity.setPublishFlag(0);
        super.updateById((Object)documentEntity);
        DocumentVO documentVO = new DocumentVO();
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        String back = null;
        try {
            this.logger.info("---url:" + this.wjOrderUrl);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)documentVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(this.wjOrderUrl, JSONObject.toJSON((Object)documentVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if (!"200".equals(jsonBack.getString("code"))) return this.queryDetail(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.queryDetail(id);
    }

    @Override
    public Boolean supplierPushSell(DocumentSupplierVO documentSupplierVO) {
        String s = JSONObject.toJSONString((Object)documentSupplierVO);
        this.logger.info("\u62a5\u4ef7\u5b9e\u4f53:" + s);
        Integer talkNum = documentSupplierVO.getTalkNum();
        Long inviteId = documentSupplierVO.getInviteId();
        Long supplierId = documentSupplierVO.getSupplierId();
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, (Object)inviteId);
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.getOne((Wrapper)lambdaDoc));
        Long documentEntityId = documentEntity.getId();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNum);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntityId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, (Object)supplierId);
        this.documentSupplierService.remove((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentEntityId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, (Object)supplierId);
        this.documentSellService.remove((Wrapper)lambdaSell);
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)BeanMapper.map((Object)documentSupplierVO, DocumentSupplierEntity.class));
        documentSupplierEntity.setDocumentId(documentEntityId);
        this.documentSupplierService.save((Object)documentSupplierEntity);
        List documentSellEntityList = BeanMapper.mapList((Iterable)documentSupplierVO.getDocumentSellList(), DocumentSellEntity.class);
        documentSellEntityList.forEach(p -> p.setDocumentId(documentEntityId));
        this.documentSellService.saveBatch(documentSellEntityList);
        return true;
    }

    @Override
    public DocumentSupplierVO getSellInfoById(Long supplierId, Long documentId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)0);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, (Object)supplierId);
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)this.documentSupplierService.getOne((Wrapper)lambdaSupplier));
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)0);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, (Object)supplierId);
        List documentSellEntityList = this.documentSellService.list((Wrapper)lambdaSell);
        DocumentSupplierVO documentSupplierVO = (DocumentSupplierVO)BeanMapper.map((Object)((Object)documentSupplierEntity), DocumentSupplierVO.class);
        List documentSellVOS = BeanMapper.mapList((Iterable)documentSellEntityList, DocumentSellVO.class);
        documentSupplierVO.setDocumentSellList(documentSellVOS);
        return documentSupplierVO;
    }

    @Override
    public DocumentVO bidDocument(Long id) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        documentEntity.setBidFlag(0);
        documentEntity.setBidTime(new Date());
        super.updateById((Object)documentEntity);
        return this.queryDetail(id);
    }

    @Override
    public DocumentVO extendDocument(DocumentRecordVO documentRecordVO) {
        DocumentRecordEntity documentRecordEntity = (DocumentRecordEntity)((Object)BeanMapper.map((Object)documentRecordVO, DocumentRecordEntity.class));
        this.documentRecordService.save((Object)documentRecordEntity);
        DocumentEntity stuffDocumentEntity = (DocumentEntity)((Object)super.selectById((Serializable)documentRecordVO.getDocumentId()));
        stuffDocumentEntity.setOfferEndTime(documentRecordVO.getNewTime());
        boolean b = super.updateById((Object)stuffDocumentEntity);
        return null;
    }

    @Override
    public DocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public DocumentVO queryDocDetail(Long id, Integer talkNum) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        DocumentVO documentVO = (DocumentVO)BeanMapper.map((Object)((Object)documentEntity), DocumentVO.class);
        Long inviteId = documentEntity.getInviteId();
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(inviteId));
        documentVO.setInviteSupplierList(BeanMapper.mapList(inviteEntity.getInviteSupplierlList(), InviteSupplierVO.class));
        documentVO.setInviteDetailList(BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class));
        if (documentVO.getBidFlag() == 1) {
            List documentSupplierList = documentVO.getDocumentSupplierList();
            List documentSupplierVOS = documentSupplierList.stream().filter(s -> s.getTalkNum().equals(talkNum)).collect(Collectors.toList());
            for (DocumentSupplierVO documentSupplierVO : documentSupplierVOS) {
                documentSupplierVO.setTenderDate(null);
                documentSupplierVO.setOfferTime(null);
                documentSupplierVO.setMemo(null);
                documentSupplierVO.setLinkId(null);
                documentSupplierVO.setLinkMobile(null);
                documentSupplierVO.setLinkName(null);
                documentSupplierVO.setTaxMemo(null);
            }
            documentVO.setDocumentSupplierList(documentSupplierVOS);
        }
        List inviteDetailVOS = BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)id);
        List documentSellEntityList = this.documentSellService.list((Wrapper)lambdaSell);
        List documentSellVOS = BeanMapper.mapList((Iterable)documentSellEntityList, DocumentSellVO.class);
        Map<Long, List<DocumentSellVO>> sellMap = documentSellVOS.stream().collect(Collectors.groupingBy(DocumentSellVO::getInviteDetailId));
        for (InviteDetailVO inviteDetailVO : inviteDetailVOS) {
            if (!sellMap.containsKey(inviteDetailVO.getId())) continue;
            List<DocumentSellVO> documentSellList = sellMap.get(inviteDetailVO.getId());
            if (documentVO.getBidFlag() == 1) {
                for (DocumentSellVO documentSellVO : documentSellList) {
                    documentSellVO.setSupplierMemo(null);
                    documentSellVO.setPriceTax(null);
                    documentSellVO.setSellMoneyTax(null);
                }
            }
            inviteDetailVO.setDocumentSupplierSellList(documentSellList);
        }
        documentVO.setDetailSupplierList(inviteDetailVOS);
        return documentVO;
    }

    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }
}

