/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.PicketageEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.bean.TalkEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.PicketageMapper;
import com.ejianc.business.fjwz.service.IDocumentRecordService;
import com.ejianc.business.fjwz.service.IDocumentSellService;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IPicketageService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.service.ITalkDetailService;
import com.ejianc.business.fjwz.service.ITalkRecordDetailService;
import com.ejianc.business.fjwz.service.ITalkRecordService;
import com.ejianc.business.fjwz.service.ITalkService;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.PicketageVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="picketageService")
public class PicketageServiceImpl
extends BaseServiceImpl<PicketageMapper, PicketageEntity>
implements IPicketageService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private ITalkRecordService talkRecordService;
    @Autowired
    private ITalkService talkService;
    @Autowired
    private ITalkRecordDetailService talkRecordDetailService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private ITalkDetailService talkDetailService;
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public PicketageVO savePicketage(Long billId, Integer type) {
        PicketageEntity entity = new PicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Long documentId = null;
        if (type == 0) {
            documentId = billId;
        }
        if (type == 1) {
            TalkEntity talkEntity = (TalkEntity)((Object)this.talkService.selectById(billId));
            talkEntity.setNextFlag(0);
            this.talkService.updateById((Object)talkEntity);
            documentId = talkEntity.getDocumentId();
        }
        DocumentEntity documentEntity = (DocumentEntity)((Object)this.documentService.selectById(documentId));
        if (type == 0) {
            documentEntity.setNextFlag(0);
            this.documentService.updateById((Object)documentEntity);
        }
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(documentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(documentEntity.getEmployeeId());
        entity.setEmployeeName(documentEntity.getEmployeeName());
        entity.setDoucumentLinkMobile(documentEntity.getEmployeeMobile());
        entity.setDoucumentLinkId(documentEntity.getDoucumentLinkId());
        entity.setDoucumentLinkName(documentEntity.getDoucumentLinkName());
        entity.setBillId(billId);
        entity.setInviteId(inviteEntity.getId());
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setProjectSourceId(inviteEntity.getProjectSourceId());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgSourceId(inviteEntity.getParentOrgSourceId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitSourceId(inviteEntity.getUnitSourceId());
        super.saveOrUpdate((Object)entity, false);
        inviteEntity.setTenderStage(TenderStageEnum.PICKETAGE.getChangeStateCode());
        this.inviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u8be2\u4ef7\u7ed3\u679c");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setFrontendUrl("picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentId);
        List supplierEntityList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        DocumentVO documentVO = this.documentService.queryDocDetail(documentId, talkNumMax);
        List documentSupplierList = documentVO.getDocumentSupplierList();
        documentSupplierList.sort(Comparator.comparing(DocumentSupplierVO::getMoneyTax));
        DocumentSupplierVO documentSupplierVO = (DocumentSupplierVO)documentSupplierList.get(0);
        documentSupplierVO.setTenderFlag(Integer.valueOf(1));
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)BeanMapper.map((Object)documentSupplierVO, DocumentSupplierEntity.class));
        this.documentSupplierService.updateById((Object)documentSupplierEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentEntity.getId());
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNumMax);
        List sellTalkMaxList = this.documentSellService.list((Wrapper)lambdaSell);
        for (DocumentSellEntity documentSellEntity : sellTalkMaxList) {
            if (documentSellEntity.getSupplierId().equals(documentSupplierEntity.getSupplierId())) {
                documentSellEntity.setBidFlag(1);
                continue;
            }
            documentSellEntity.setBidFlag(0);
        }
        this.documentSellService.updateBatchById(sellTalkMaxList);
        return this.queryDetail(entity.getId());
    }

    @Override
    public PicketageVO queryDetail(Long id) {
        PicketageEntity picketageEntity = (PicketageEntity)((Object)super.selectById((Serializable)id));
        PicketageVO picketageVO = (PicketageVO)BeanMapper.map((Object)((Object)picketageEntity), PicketageVO.class);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)picketageEntity.getBillId());
        List supplierEntityList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        DocumentEntity entity = (DocumentEntity)((Object)this.documentService.selectById(picketageEntity.getBillId()));
        DocumentVO stuffDocumentVO = (DocumentVO)BeanMapper.map((Object)((Object)entity), DocumentVO.class);
        DocumentVO documentVO = this.documentService.queryDocDetail(picketageEntity.getBillId(), talkNumMax);
        List documentSupplierList = documentVO.getDocumentSupplierList();
        List supplierVOS = documentSupplierList.stream().filter(s -> s.getTenderFlag().equals(1)).collect(Collectors.toList());
        documentSupplierList.sort(Comparator.comparing(DocumentSupplierVO::getMoneyTax));
        picketageVO.setSupplierList(documentSupplierList);
        DocumentSupplierVO documentSupplierVO = (DocumentSupplierVO)supplierVOS.get(0);
        ArrayList<DocumentSupplierVO> documentSupplierVOS = new ArrayList<DocumentSupplierVO>();
        documentSupplierVOS.add(documentSupplierVO);
        picketageVO.setSupplierBidList(documentSupplierVOS);
        return picketageVO;
    }

    @Override
    public PicketageVO saveOrUpdate(PicketageVO saveOrUpdateVO) {
        PicketageEntity entity = (PicketageEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PicketageEntity.class));
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, (Object)saveOrUpdateVO.getInviteId());
        DocumentEntity documentEntity = (DocumentEntity)((Object)this.documentService.getOne((Wrapper)lambdaDoc));
        super.saveOrUpdate((Object)entity, false);
        List supplierBidList = saveOrUpdateVO.getSupplierBidList();
        if (CollectionUtils.isNotEmpty((Collection)supplierBidList)) {
            DocumentSupplierVO documentSupplierBidVO = (DocumentSupplierVO)supplierBidList.get(0);
            LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
            lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntity.getId());
            List supplierEntityList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
            List talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
            Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
            List supplierEntities = supplierEntityList.stream().filter(s -> s.getTalkNum().equals(talkNumMax)).collect(Collectors.toList());
            DocumentSupplierEntity documentSupplierBidEntity = (DocumentSupplierEntity)((Object)supplierEntities.stream().findFirst().get());
            for (DocumentSupplierEntity documentSupplierEntity : supplierEntities) {
                if (documentSupplierEntity.getSupplierId().equals(documentSupplierBidVO.getSupplierId())) {
                    documentSupplierBidEntity.setTenderFlag(1);
                    continue;
                }
                documentSupplierBidEntity.setTenderFlag(0);
            }
            this.documentSupplierService.updateBatchById(supplierEntities);
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentEntity.getId());
            lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNumMax);
            List sellTalkMaxList = this.documentSellService.list((Wrapper)lambdaSell);
            for (DocumentSellEntity documentSellEntity : sellTalkMaxList) {
                if (documentSellEntity.getSupplierId().equals(documentSupplierBidVO.getSupplierId())) {
                    documentSellEntity.setBidFlag(1);
                    continue;
                }
                documentSellEntity.setBidFlag(0);
            }
            this.documentSellService.updateBatchById(sellTalkMaxList);
        }
        return null;
    }
}

