/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.bean.TalkDetailEntity;
import com.ejianc.business.fjwz.bean.TalkEntity;
import com.ejianc.business.fjwz.bean.TalkRecordDetailEntity;
import com.ejianc.business.fjwz.bean.TalkRecordEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.TalkMapper;
import com.ejianc.business.fjwz.service.IDocumentRecordService;
import com.ejianc.business.fjwz.service.IDocumentSellService;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.service.ITalkDetailService;
import com.ejianc.business.fjwz.service.ITalkRecordDetailService;
import com.ejianc.business.fjwz.service.ITalkRecordService;
import com.ejianc.business.fjwz.service.ITalkService;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.TalkDetailVO;
import com.ejianc.business.fjwz.vo.TalkRecordVO;
import com.ejianc.business.fjwz.vo.TalkVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="talkService")
public class TalkServiceImpl
extends BaseServiceImpl<TalkMapper, TalkEntity>
implements ITalkService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private ITalkRecordService talkRecordService;
    @Autowired
    private ITalkRecordDetailService talkRecordDetailService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private ITalkDetailService talkDetailService;
    private static final String BILL_CODE = "talk-code";

    @Override
    public TalkVO saveTalk(Long documentId) {
        TalkEntity entity = new TalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DocumentEntity documentEntity = (DocumentEntity)((Object)this.documentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.documentService.saveOrUpdate((Object)documentEntity);
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(documentEntity.getInviteId()));
        entity.setProjectCode(documentEntity.getProjectCode());
        entity.setInviteId(documentEntity.getInviteId());
        entity.setProjectId(documentEntity.getProjectId());
        entity.setProjectSourceId(documentEntity.getProjectSourceId());
        entity.setProjectName(documentEntity.getProjectName());
        entity.setOrgId(documentEntity.getOrgId());
        entity.setOrgName(documentEntity.getOrgName());
        entity.setParentOrgId(documentEntity.getParentOrgId());
        entity.setParentOrgSourceId(documentEntity.getParentOrgSourceId());
        entity.setParentOrgName(documentEntity.getParentOrgName());
        entity.setDocumentId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setTalkName(inviteEntity.getTenderName());
        super.save((Object)entity);
        inviteEntity.setTenderStage(TenderStageEnum.TALK.getChangeStateCode());
        this.inviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(documentEntity.getInviteId());
        processEntity.setFrontendUrl("talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        TalkVO vo = (TalkVO)BeanMapper.map((Object)((Object)entity), TalkVO.class);
        return this.queryDetail(vo.getId());
    }

    @Override
    public TalkVO queryDetail(Long id) {
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)id));
        TalkVO talkVO = (TalkVO)BeanMapper.map((Object)((Object)talkEntity), TalkVO.class);
        Integer talkNum = talkEntity.getTalkNum();
        if (talkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        DocumentVO documentVO = this.documentService.queryDocDetail(talkEntity.getDocumentId(), talkNum);
        talkVO.setInviteDetailList(documentVO.getInviteDetailList());
        talkVO.setInviteSupplierList(documentVO.getInviteSupplierList());
        talkVO.setDetailSupplierList(documentVO.getDetailSupplierList());
        talkVO.setDocumentSupplierList(documentVO.getDocumentSupplierList());
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(TalkRecordEntity::getDocumentId, (Object)talkEntity.getDocumentId());
        lambdaRecord.orderByAsc(TalkRecordEntity::getTalkNum);
        List talkRecordEntityList = this.talkRecordService.list((Wrapper)lambdaRecord);
        List talkRecordList = BeanMapper.mapList((Iterable)talkRecordEntityList, TalkRecordVO.class);
        talkVO.setTalkRecordList(talkRecordList);
        return talkVO;
    }

    @Override
    public TalkVO publishTalk(Long id) {
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)id));
        talkEntity.setPublishFlag(0);
        super.updateById((Object)talkEntity);
        return this.queryDetail(id);
    }

    @Override
    public TalkVO extendTalk(TalkDetailVO talkDetailVO) {
        TalkDetailEntity talkDetailEntity = (TalkDetailEntity)((Object)BeanMapper.map((Object)talkDetailVO, TalkDetailEntity.class));
        this.talkDetailService.save((Object)talkDetailEntity);
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)talkDetailVO.getTalkId()));
        talkEntity.setTalkEndTime(talkDetailVO.getNewTime());
        boolean b = super.updateById((Object)talkEntity);
        return this.queryDetail(talkDetailVO.getTalkId());
    }

    @Override
    public TalkVO againSaveTalk(Long id) {
        TalkEntity entity = new TalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(talkEntity.getProjectCode());
        entity.setProjectId(talkEntity.getProjectId());
        entity.setProjectSourceId(talkEntity.getProjectSourceId());
        entity.setProjectName(talkEntity.getProjectName());
        entity.setOrgId(talkEntity.getOrgId());
        entity.setOrgName(talkEntity.getOrgName());
        entity.setParentOrgId(talkEntity.getParentOrgId());
        entity.setParentOrgSourceId(talkEntity.getParentOrgSourceId());
        entity.setParentOrgName(talkEntity.getParentOrgName());
        entity.setDocumentId(talkEntity.getDocumentId());
        entity.setUnitId(talkEntity.getUnitId());
        entity.setUnitName(talkEntity.getUnitName());
        entity.setUnitSourceId(talkEntity.getUnitSourceId());
        entity.setInviteId(talkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(talkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        super.save((Object)entity);
        TalkRecordEntity talkRecordEntity = (TalkRecordEntity)((Object)BeanMapper.map((Object)((Object)talkEntity), TalkRecordEntity.class));
        talkRecordEntity.setTalkId(talkEntity.getId());
        talkRecordEntity.setId(null);
        this.talkRecordService.save((Object)talkRecordEntity);
        List<TalkDetailEntity> talkDetailList = talkEntity.getTalkDetailList();
        List talkRecordDetailEntityList = BeanMapper.mapList(talkDetailList, TalkRecordDetailEntity.class);
        for (TalkRecordDetailEntity talkRecordDetailEntity : talkRecordDetailEntityList) {
            talkRecordDetailEntity.setId(null);
            talkRecordDetailEntity.setRecordId(talkRecordEntity.getId());
        }
        this.talkRecordDetailService.saveBatch(talkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)talkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        this.addLastSell(talkEntity.getTalkNum(), talkEntity.getDocumentId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public TalkVO replenishSell(Long id) {
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = talkEntity.getTalkNum();
        Long documentId = talkEntity.getDocumentId();
        this.addLastSell(talkNum, documentId);
        return new TalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        TalkEntity talkEntity = (TalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = talkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)talkEntity.getDocumentId());
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(DocumentSupplierEntity::getDocumentId, (Object)talkEntity.getDocumentId());
        lambdaSupplierFirst.eq(DocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.documentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(DocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(DocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.documentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(DocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, DocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }
        List supplierNewPk = documentSupplierEntityNewList.stream().map(DocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        for (DocumentSupplierEntity documentSupplierEntity : documentSupplierEntityNewList) {
            documentSupplierEntity.setId(IdWorker.getId());
            documentSupplierEntity.setTalkNum(talkNum);
        }
        this.documentSupplierService.saveBatch(documentSupplierEntityNewList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(DocumentSellEntity::getSupplierId, supplierNewPk);
        List sellList = this.documentSellService.list((Wrapper)lambdaSell);
        for (DocumentSellEntity stuffDocumentSellEntity : sellList) {
            stuffDocumentSellEntity.setId(null);
            stuffDocumentSellEntity.setTalkNum(talkNum);
        }
        this.documentSellService.saveBatch(sellList);
    }
}

