/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.DisposeEntity;
import com.ejianc.business.fjwz.mapper.InviteDetailMapper;
import com.ejianc.business.fjwz.service.IDisposeDetailService;
import com.ejianc.business.fjwz.service.IDisposeService;
import com.ejianc.business.fjwz.util.PageUtil;
import com.ejianc.business.fjwz.vo.DisposeDetailVO;
import com.ejianc.business.fjwz.vo.DisposeVO;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dispose"})
public class DisposeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DISPOSE";
    @Autowired
    private IDisposeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDisposeDetailService detailService;
    @Autowired
    private InviteDetailMapper inviteMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeEntity entity = (DisposeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DisposeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(id));
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "materialTypeNames"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DisposeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "materialTypeNames"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, DisposeVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("Dispose-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryParentOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse orgVO = this.iOrgApi.detailById(((OrgVO)this.iOrgApi.detailById(orgId).getData()).getParentId());
        return CommonResponse.success((Object)orgVO.getData());
    }

    @RequestMapping(value={"/refDisposeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSON.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DisposeDetailVO> list = this.detailService.getMaterialDetail(wrapper);
        List materialListId = list.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<DisposeDetailVO> refList = new ArrayList();
        if (!materialListId.isEmpty()) {
            String ids = StringUtils.join(materialListId, (String)",");
            List<InviteDetailVO> dList = this.inviteMapper.getByMaterialId(ids, wrapper);
            Map maps = dList.stream().collect(Collectors.toMap(InviteDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
            for (DisposeDetailVO detailVO : list) {
                if (!maps.containsKey(detailVO.getMaterialId())) {
                    detailVO.setSurplusNum(detailVO.getSumNum());
                    continue;
                }
                detailVO.setSurplusNum(ComputeUtil.safeSub((BigDecimal)detailVO.getSumNum(), (BigDecimal)((InviteDetailVO)maps.get(detailVO.getMaterialId())).getTenderNum()));
                if (detailVO.getSurplusNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                refList.add(detailVO);
            }
        }
        Page pageData = new Page();
        pageData.setCurrent((long)pageNumber.intValue());
        pageData.setSize((long)pageSize.intValue());
        pageData.setTotal((long)refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSON.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        ArrayList checkList = new ArrayList();
        List materialListId = checkList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Object> list = new ArrayList();
        if (!materialListId.isEmpty()) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            String ids = StringUtils.join(materialListId, (String)",");
            list = this.detailService.getDisposeDetail(ids, wrapper);
        }
        Map maps = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        List<DisposeDetailVO> refList = new ArrayList();
        for (DisposeDetailVO detailVO : checkList) {
            if (!maps.containsKey(detailVO.getMaterialId())) {
                detailVO.setSurplusNum(detailVO.getSumNum());
                detailVO.setSumLossRate(BigDecimal.ZERO);
                continue;
            }
            detailVO.setSurplusNum(ComputeUtil.safeSub((BigDecimal)detailVO.getSumNum(), (BigDecimal)((DisposeDetailVO)maps.get(detailVO.getMaterialId())).getSumNum()));
            detailVO.setSumLossRate(((DisposeDetailVO)maps.get(detailVO.getMaterialId())).getSumLossRate());
            if (detailVO.getSurplusNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            refList.add(detailVO);
        }
        Page pageData = new Page();
        pageData.setCurrent((long)pageNumber.intValue());
        pageData.setSize((long)pageSize.intValue());
        pageData.setTotal((long)refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryCheckNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, DisposeDetailVO>> queryCheckNum(@RequestBody DisposeDetailVO vo) {
        HashMap<Long, DisposeDetailVO> maps = new HashMap<Long, DisposeDetailVO>();
        ArrayList checkList = new ArrayList();
        Map checkMap = checkList.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        String ids = StringUtils.join((Iterable)vo.getIds(), (String)",");
        if (checkList.isEmpty()) {
            return CommonResponse.success(maps);
        }
        List<DisposeDetailVO> list = this.detailService.getDisposeDetails(ids);
        Map map = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        for (Long id : vo.getIds()) {
            DisposeDetailVO dvo = (DisposeDetailVO)checkMap.get(id);
            if (!map.containsKey(id)) {
                dvo.setSurplusNum(dvo.getSumNum());
                dvo.setSumLossRate(BigDecimal.ZERO);
            } else {
                dvo.setSurplusNum(ComputeUtil.safeSub((BigDecimal)dvo.getSumNum(), (BigDecimal)((DisposeDetailVO)map.get(id)).getSumNum()));
                dvo.setSumLossRate(((DisposeDetailVO)map.get(id)).getSumLossRate());
            }
            maps.put(id, dvo);
        }
        return CommonResponse.success(maps);
    }
}

