/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.vo.InviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invite"})
@Api(value="\u8be2\u4ef7\u7acb\u9879-\u4e3b\u8868", tags={"\u8be2\u4ef7\u7acb\u9879-\u4e3b\u8868"})
public class InviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessService processService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "cscec5b-invite-code";
    @Autowired
    private IInviteService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody InviteVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(@RequestParam Long id) {
        InviteEntity entity = (InviteEntity)((Object)this.service.selectById(id));
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getAType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = this.service.getAbolishType(tenderId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6d41/\u5e9f\u6807\u72b6\u6001\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        boolean mobile = param.getParams().containsKey("projectId");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List inviteVOS = BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)inviteVOS)) {
            for (InviteVO inviteVO : inviteVOS) {
                inviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(inviteVO.getTenderStage()).getDescription());
            }
        }
        pageData.setRecords(inviteVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        boolean mobile = param.getParams().containsKey("projectId");
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List inviteVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            inviteVOList = BeanMapper.mapList((Iterable)list, InviteVO.class);
        }
        for (InviteVO inviteVO : inviteVOList) {
            inviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(inviteVO.getTenderStage()).getDescription());
            inviteVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)inviteVO.getBillState()).getDescription());
        }
        beans.put("records", inviteVOList);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        JSONObject _con = JSONObject.parseObject((String)condition);
        if (_con.containsKey((Object)"projectId")) {
            Long projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            param.getParams().put("supplierId", new Parameter("sql", (Object)"supplier_id is not null"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

