/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.LossSetEntity;
import com.ejianc.business.fjwz.service.ILossSetService;
import com.ejianc.business.fjwz.vo.LossSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"lossSet"})
@Api(value="\u635f\u8017\u7387\u8bbe\u7f6e", tags={"\u635f\u8017\u7387\u8bbe\u7f6e"})
public class LossSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ILossSetService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialApi materialApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LossSetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody LossSetVO saveOrUpdateVO) {
        LossSetEntity entity = (LossSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LossSetEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setEmployeeId(userContext.getEmployeeId());
        entity.setEmployeeName(userContext.getEmployeeName());
        entity.setBillTime(new Date());
        if (entity.getId() == null) {
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
            List list = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"material_type_id", (Object)entity.getMaterialTypeId())).eq((Object)"org_id", (Object)entity.getOrgId()));
            if (!list.isEmpty()) {
                throw new BusinessException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d!");
            }
            CommonResponse materialCategoryVO = this.materialApi.queryCategoryById(entity.getMaterialTypeId());
            entity.setCategoryInnerCode(((MaterialCategoryVO)materialCategoryVO.getData()).getInnerCode());
            entity.setCategorySourceId(((MaterialCategoryVO)materialCategoryVO.getData()).getSourceId());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LossSetVO> queryDetail(@RequestParam Long id) {
        LossSetEntity entity = (LossSetEntity)((Object)this.service.selectById(id));
        LossSetVO vo = (LossSetVO)BeanMapper.map((Object)((Object)entity), LossSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LossSetVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LossSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialTypeCode", "materialTypeName", "lossRate", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LossSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/turnSwitch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> turnSwitch(@RequestBody LossSetVO vo) {
        String msg = "";
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(LossSetEntity::getStatus, (Object)vo.getStatus());
        lambd.eq(BaseEntity::getId, (Object)vo.getId());
        this.service.update((Wrapper)lambd);
        msg = vo.getStatus() == 0 ? "\u505c\u7528\u6210\u529f\uff01" : "\u542f\u7528\u6210\u529f\uff01";
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/getLossRate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getLossRate(@RequestBody LossSetVO vo) {
        List cids;
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        CommonResponse voLists = this.materialApi.queryCategoryListByChildren(vo.getIds());
        List<Object> vids = new ArrayList();
        HashMap<Long, List> vidMap = new HashMap<Long, List>();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)voLists.getData()))) {
            Map map = ((List)voLists.getData()).stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (k1, k2) -> k2));
            for (Long id : vo.getIds()) {
                cids = Arrays.stream(((MaterialCategoryVO)map.get(id)).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                Collections.reverse(cids);
                vidMap.put(id, cids);
                vids.addAll(cids);
            }
        } else {
            throw new BusinessException("\u7269\u6599\u5206\u7c7b\u6863\u6848\u672a\u67e5\u5230\u5f53\u524d\u5206\u7c7b\u53ca\u4e0a\u7ea7\u5206\u7c7b\uff01");
        }
        vids = vids.stream().distinct().collect(Collectors.toList());
        List list = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"material_type_id", vids)).eq((Object)"org_id", (Object)vo.getOrgId())).eq((Object)"status", (Object)1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", result);
        }
        Map maps = list.stream().collect(Collectors.toMap(LossSetEntity::getMaterialTypeId, Function.identity(), (k1, k2) -> k2));
        block1: for (Long id : vo.getIds()) {
            if (result.containsKey(id)) continue;
            cids = (List)vidMap.get(id);
            for (Long cid : cids) {
                if (!maps.containsKey(cid)) continue;
                result.put(id, ((LossSetEntity)((Object)maps.get(cid))).getLossRate());
                continue block1;
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", result);
    }
}

